/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.httpcomponents;

import guru.nidi.ramltester.httpcomponents.HttpComponentsRamlMessage;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.FormDecoder;
import guru.nidi.ramltester.util.UriComponents;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;

public class HttpComponentsRamlRequest
extends HttpComponentsRamlMessage
implements RamlRequest {
    private final String path;
    private final String url;
    private final HttpRequest request;

    public HttpComponentsRamlRequest(HttpHost host, HttpRequest request) {
        this.request = request;
        this.path = UriComponents.fromHttpUrl(request.getRequestLine().getUri()).getPath();
        this.url = host.toString() + request.getRequestLine().getUri();
    }

    public HttpComponentsRamlRequest(HttpUriRequest request) {
        this.request = request;
        this.path = request.getURI().getPath();
        this.url = request.getURI().toString();
    }

    @Override
    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        return baseUri == null ? this.url : baseUri + this.path;
    }

    @Override
    public String getMethod() {
        return this.request.getRequestLine().getMethod();
    }

    @Override
    public Values getQueryValues() {
        UriComponents uriComponents = UriComponents.fromHttpUrl(this.request.getRequestLine().getUri());
        return uriComponents.getQueryParameters();
    }

    @Override
    public Values getFormValues() {
        return new FormDecoder().decode(this);
    }

    @Override
    public Values getHeaderValues() {
        return this.headerValuesOf((HttpMessage)this.request);
    }

    @Override
    public String getContentType() {
        return this.contentTypeOf((HttpMessage)this.request);
    }

    @Override
    public byte[] getContent() {
        return this.request instanceof HttpEntityEnclosingRequest ? this.contentOf(this.buffered((HttpEntityEnclosingRequest)this.request).getEntity()) : null;
    }
}

