/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.junit;

import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlViolationMessage;
import guru.nidi.ramltester.core.RamlViolations;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

class NoViolationsMatcher
extends TypeSafeMatcher<RamlReport> {
    private final boolean validation;
    private final boolean request;
    private final boolean response;

    public NoViolationsMatcher(boolean validation, boolean request, boolean response) {
        this.validation = validation;
        this.request = request;
        this.response = response;
    }

    protected boolean matchesSafely(RamlReport report) {
        return !(this.validation && !report.getValidationViolations().isEmpty() || this.request && !report.getRequestViolations().isEmpty() || this.response && !report.getResponseViolations().isEmpty());
    }

    public void describeTo(Description description) {
        description.appendText("To be empty");
    }

    protected void describeMismatchSafely(RamlReport item, Description description) {
        if (this.validation) {
            this.describeList(description, "\nValidation violations:", item.getValidationViolations());
        }
        if (this.request) {
            this.describeList(description, "\nRequest violations:", item.getRequestViolations());
        }
        if (this.response) {
            this.describeList(description, "\nResponse violations:", item.getResponseViolations());
        }
    }

    private void describeList(Description description, String start, RamlViolations violations) {
        if (!violations.isEmpty()) {
            description.appendText(start);
            for (RamlViolationMessage s : violations) {
                description.appendText("\n  - ").appendText(s.getMessage().replace("\n", "\n    "));
            }
        }
    }
}

