/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.restassured3;

import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.restassured3.RestAssuredRamlMessage;
import io.restassured.specification.FilterableRequestSpecification;

class RestAssuredRamlRequest
extends RestAssuredRamlMessage
implements RamlRequest {
    private final FilterableRequestSpecification requestSpec;

    RestAssuredRamlRequest(FilterableRequestSpecification requestSpec) {
        this.requestSpec = requestSpec;
    }

    @Override
    public Values getHeaderValues() {
        return this.headersToValues(this.requestSpec.getHeaders());
    }

    @Override
    public String getContentType() {
        return this.requestSpec.getContentType();
    }

    @Override
    public byte[] getContent() {
        Object body = this.requestSpec.getBody();
        if (body == null) {
            return null;
        }
        if (body instanceof String) {
            return ((String)body).getBytes();
        }
        if (body instanceof byte[]) {
            return (byte[])body;
        }
        throw new RamlCheckerException("Cannot process body of type " + body.getClass());
    }

    @Override
    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        return baseUri == null || baseUri.length() == 0 ? this.requestSpec.getURI() : this.requestSpec.getURI().replace(this.requestSpec.getBaseUri(), baseUri);
    }

    @Override
    public String getMethod() {
        return this.requestSpec.getMethod();
    }

    @Override
    public Values getQueryValues() {
        return this.mapToValues(this.requestSpec.getQueryParams());
    }

    @Override
    public Values getFormValues() {
        return this.mapToValues(this.requestSpec.getFormParams());
    }
}

