/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.util;

import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.FileValue;
import guru.nidi.ramltester.util.InvalidMediaTypeException;
import guru.nidi.ramltester.util.IoUtils;
import guru.nidi.ramltester.util.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class FormDecoder {
    private static final String DEFAULT_CHARSET = "iso-8859-1";
    private static final MediaType MULTIPART = MediaType.valueOf("multipart/form-data");
    private static final MediaType URL_ENCODED = MediaType.valueOf("application/x-www-form-urlencoded");
    private static final Pattern QUERY_PARAM = Pattern.compile("([^&=]+)(=?)([^&]+)?");
    private static final int GROUP_NAME = 1;
    private static final int GROUP_EQUAL = 2;
    private static final int GROUP_VALUE = 3;

    public static boolean supportsFormParameters(MediaType mediaType) {
        return mediaType.isCompatibleWith(URL_ENCODED) || mediaType.isCompatibleWith(MULTIPART);
    }

    public Values decode(RamlRequest request) {
        MediaType type;
        if (request.getContentType() == null) {
            return new Values();
        }
        try {
            type = MediaType.valueOf(request.getContentType());
        }
        catch (InvalidMediaTypeException e) {
            return new Values();
        }
        if (type.isCompatibleWith(URL_ENCODED)) {
            String charset = type.getCharset(DEFAULT_CHARSET);
            try {
                String content = IoUtils.readIntoString(new InputStreamReader((InputStream)new ByteArrayInputStream(request.getContent()), charset));
                return this.decodeUrlEncoded(content, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unknown charset " + charset, e);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (type.isCompatibleWith(MULTIPART)) {
            return this.decodeMultipart(request);
        }
        return new Values();
    }

    private static String charset(String contentType) {
        if (contentType == null) {
            return DEFAULT_CHARSET;
        }
        try {
            return MediaType.valueOf(contentType).getCharset(DEFAULT_CHARSET);
        }
        catch (InvalidMediaTypeException e) {
            return DEFAULT_CHARSET;
        }
    }

    private Values decodeMultipart(RamlRequest request) {
        try {
            Values values = new Values();
            RamlRequestFileUploadContext context = new RamlRequestFileUploadContext(request);
            FileItemIterator iter = new ServletFileUpload().getItemIterator((RequestContext)context);
            while (iter.hasNext()) {
                FileItemStream itemStream = iter.next();
                values.addValue(itemStream.getFieldName(), this.valueOf(itemStream));
            }
            return values;
        }
        catch (IOException | FileUploadException e) {
            throw new IllegalArgumentException("Could not parse multipart request", e);
        }
    }

    private Object valueOf(FileItemStream itemStream) throws IOException {
        if (itemStream.isFormField()) {
            String charset = FormDecoder.charset(itemStream.getContentType());
            return IoUtils.readIntoString(new InputStreamReader(itemStream.openStream(), charset));
        }
        return new FileValue();
    }

    private Values decodeUrlEncoded(String content, String charset) {
        Values q = new Values();
        if (content != null) {
            Matcher m = QUERY_PARAM.matcher(content);
            while (m.find()) {
                String name = this.urlDecode(m.group(1), charset);
                String eq = m.group(2);
                String value = m.group(3);
                q.addValue(name, value == null ? (eq != null && eq.length() > 0 ? "" : null) : this.urlDecode(value, charset));
            }
        }
        return q;
    }

    private String urlDecode(String part, String charset) {
        try {
            return URLDecoder.decode(part, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unknown charset " + charset, e);
        }
    }

    private static class RamlRequestFileUploadContext
    implements RequestContext {
        private final RamlRequest request;

        public RamlRequestFileUploadContext(RamlRequest request) {
            this.request = request;
        }

        public String getCharacterEncoding() {
            return FormDecoder.charset(this.request.getContentType());
        }

        public String getContentType() {
            return this.request.getContentType();
        }

        public int getContentLength() {
            return this.request.getContent().length;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.request.getContent());
        }
    }
}

