/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;

public class Message {
    private static final Properties MESSAGES = new Properties();
    protected final String key;
    protected final Object[] params;

    public Message(String key, Object ... params) {
        this.key = key;
        this.params = params;
    }

    public Message withMessageParam(String key, Object ... params) {
        return this.withParam(new Message(key, params));
    }

    public Message withInnerParam(Message param) {
        return new InnerMessage(this.key, this.addParam(param));
    }

    public Message withParam(Object param) {
        return new Message(this.key, this.addParam(param));
    }

    private Object[] addParam(Object param) {
        Object[] newParams = new Object[this.params.length + 1];
        System.arraycopy(this.params, 0, newParams, 0, this.params.length);
        newParams[newParams.length - 1] = param;
        return newParams;
    }

    public String toString() {
        String pattern = MESSAGES.getProperty(this.key);
        return MessageFormat.format(pattern == null ? this.key : pattern, this.params);
    }

    static {
        try {
            MESSAGES.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("guru/nidi/ramltester/messages.properties"));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class InnerMessage
    extends Message {
        public InnerMessage(String key, Object ... params) {
            super(key, params);
        }

        @Override
        public Message withParam(Object p) {
            Object[] newParams = new Object[this.params.length];
            System.arraycopy(this.params, 0, newParams, 0, this.params.length);
            newParams[this.params.length - 1] = ((Message)newParams[this.params.length - 1]).withParam(p);
            return new Message(this.key, newParams);
        }
    }
}

