/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester;

import guru.nidi.ramltester.RamlDefinition;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportAggregator;
import guru.nidi.ramltester.core.Usage;
import guru.nidi.ramltester.core.UsageBuilder;
import guru.nidi.ramltester.core.UsageProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiReportAggregator
implements ReportAggregator {
    private final Map<String, List<RamlReport>> reports = new HashMap<String, List<RamlReport>>();

    @Override
    public RamlReport addReport(RamlReport report) {
        if (report != null) {
            String title = report.getRaml().getTitle();
            List<RamlReport> reportList = this.getOrCreateReports(title);
            reportList.add(report);
        }
        return report;
    }

    public List<RamlReport> getReports(RamlDefinition definition) {
        return this.getOrCreateReports(definition.getRaml().getTitle());
    }

    public Usage getUsage(RamlDefinition definition) {
        return UsageBuilder.usage(definition.getRaml(), this.getReports(definition));
    }

    public UsageProvider usageProvider(final RamlDefinition definition) {
        return new UsageProvider(){

            @Override
            public Usage getUsage() {
                return MultiReportAggregator.this.getUsage(definition);
            }
        };
    }

    public Iterable<Map.Entry<String, List<RamlReport>>> reports() {
        return this.reports.entrySet();
    }

    @Override
    public Iterable<Map.Entry<String, Usage>> usages() {
        HashMap<String, Usage> res = new HashMap<String, Usage>();
        for (Map.Entry<String, List<RamlReport>> entry : this.reports.entrySet()) {
            res.put(entry.getKey(), UsageBuilder.usage(entry.getValue().get(0).getRaml(), entry.getValue()));
        }
        return res.entrySet();
    }

    @Override
    public void clear() {
        this.reports.clear();
    }

    private List<RamlReport> getOrCreateReports(String name) {
        List<RamlReport> reportList = this.reports.get(name);
        if (reportList == null) {
            reportList = new ArrayList<RamlReport>();
            this.reports.put(name, reportList);
        }
        return reportList;
    }
}

