/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester;

import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportAggregator;
import guru.nidi.ramltester.core.Usage;
import guru.nidi.ramltester.core.UsageBuilder;
import guru.nidi.ramltester.core.UsageProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.raml.model.Raml;

public class SimpleReportAggregator
implements ReportAggregator,
UsageProvider {
    private Raml raml;
    private final List<RamlReport> reports = new ArrayList<RamlReport>();

    @Override
    public RamlReport addReport(RamlReport report) {
        if (report != null) {
            if (this.raml == null) {
                this.raml = report.getRaml();
            } else if (!this.raml.getTitle().equals(report.getRaml().getTitle())) {
                throw new IllegalArgumentException("This aggregator can only be used with one RamlDefinition. To work with multiple RamlDefinitions, use MultiReportAggregator.");
            }
            this.reports.add(report);
        }
        return report;
    }

    @Override
    public Iterable<Map.Entry<String, Usage>> usages() {
        return Collections.singletonMap(this.raml.getTitle(), UsageBuilder.usage(this.raml, this.reports)).entrySet();
    }

    @Override
    public void clear() {
        this.reports.clear();
    }

    public List<RamlReport> getReports() {
        return this.reports;
    }

    protected Raml getRaml() {
        return this.raml;
    }

    @Override
    public Usage getUsage() {
        return UsageBuilder.usage(this.raml, this.getReports());
    }
}

