/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CheckerConfig;
import guru.nidi.ramltester.core.CheckerHelper;
import guru.nidi.ramltester.core.ContentNegotiationChecker;
import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.MediaTypeMatch;
import guru.nidi.ramltester.core.NamedReader;
import guru.nidi.ramltester.core.ParameterChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlViolationException;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.core.SecurityExtractor;
import guru.nidi.ramltester.core.Usage;
import guru.nidi.ramltester.core.UsageBuilder;
import guru.nidi.ramltester.core.VariableMatcher;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.RamlResponse;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.FormDecoder;
import guru.nidi.ramltester.util.Message;
import guru.nidi.ramltester.util.UriComponents;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Protocol;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.AbstractParam;

public class RamlChecker {
    private final CheckerConfig config;
    private RamlViolations requestViolations;
    private RamlViolations responseViolations;
    private Locator locator;
    private Usage usage;

    public RamlChecker(CheckerConfig config) {
        this.config = config;
    }

    public RamlReport check(RamlRequest request) {
        return this.check(request, null);
    }

    public RamlReport check(RamlRequest request, RamlResponse response) {
        RamlReport report = new RamlReport(this.config.raml);
        this.usage = report.getUsage();
        this.requestViolations = report.getRequestViolations();
        this.responseViolations = report.getResponseViolations();
        this.locator = new Locator();
        try {
            Action action = this.findAction(request);
            SecurityExtractor security = new SecurityExtractor(this.config.raml, action, this.requestViolations);
            security.check(this.requestViolations);
            this.checkRequest(request, action, security);
            if (response != null) {
                MediaTypeMatch typeMatch = this.checkResponse(response, action, security);
                new ContentNegotiationChecker(this.requestViolations, this.responseViolations).check(request, response, action, typeMatch);
            }
        }
        catch (RamlViolationException e) {
            // empty catch block
        }
        if (this.config.failFast && !report.isEmpty()) {
            throw new RamlViolationException(report);
        }
        return report;
    }

    public Action findAction(RamlRequest request) {
        UriComponents requestUri = UriComponents.fromHttpUrl(request.getRequestUrl(this.config.baseUri, this.config.includeServletPath));
        if (this.config.raml.getBaseUri() == null) {
            UriComponents ramlUri = UriComponents.fromHttpUrl("http://server");
            VariableMatcher pathMatch = this.getPathMatch(requestUri, ramlUri);
            return this.findAction(pathMatch.getSuffix(), request.getMethod());
        }
        UriComponents ramlUri = UriComponents.fromHttpUrl(this.config.raml.getBaseUri());
        VariableMatcher hostMatch = this.getHostMatch(requestUri, ramlUri);
        VariableMatcher pathMatch = this.getPathMatch(requestUri, ramlUri);
        Action action = this.findAction(pathMatch.getSuffix(), request.getMethod());
        this.checkProtocol(action, requestUri, ramlUri);
        this.checkBaseUriParameters(hostMatch, pathMatch, action);
        return action;
    }

    private Action findAction(String path, String method) {
        Resource resource = this.findResourceByPath(path);
        UsageBuilder.resourceUsage(this.usage, resource).incUses(1);
        Action action = resource.getAction(method);
        if (action == null) {
            this.requestViolations.add("action.undefined", this.locator, method);
            throw new RamlViolationException();
        }
        UsageBuilder.actionUsage(this.usage, action).incUses(1);
        this.locator.action(action);
        return action;
    }

    private Resource findResourceByPath(String resourcePath) {
        Values values = new Values();
        Resource resource = CheckerHelper.findResource(resourcePath, this.config.raml.getResources(), values);
        if (resource == null) {
            this.requestViolations.add("resource.undefined", resourcePath);
            throw new RamlViolationException();
        }
        this.locator.resource(resource);
        this.checkUriParams(values, resource);
        return resource;
    }

    public void checkRequest(RamlRequest request, Action action, SecurityExtractor security) {
        this.checkQueryParameters(request.getQueryValues(), action, security);
        this.checkRequestHeaderParameters(request.getHeaderValues(), action, security);
        MediaTypeMatch typeMatch = MediaTypeMatch.find(this.requestViolations, request, action.getBody(), this.locator);
        if (typeMatch != null) {
            this.locator.requestMime(typeMatch.getMatchingMime());
            if (FormDecoder.supportsFormParameters(typeMatch.getTargetType())) {
                this.checkFormParameters(action, request.getFormValues(), typeMatch.getMatchingMime());
            } else {
                this.checkSchema(this.requestViolations, request.getContent(), typeMatch);
            }
        }
    }

    private void checkFormParameters(Action action, Values values, MimeType mimeType) {
        Map formParameters;
        if (mimeType.getSchema() != null) {
            this.requestViolations.add("schema.superfluous", this.locator);
        }
        if ((formParameters = mimeType.getFormParameters()) == null) {
            this.requestViolations.add("formParameters.missing", this.locator);
        } else {
            this.checkFormParametersValues(action, mimeType, values, formParameters);
        }
    }

    private void checkFormParametersValues(Action action, MimeType mimeType, Values values, Map<String, List<? extends AbstractParam>> formParameters) {
        UsageBuilder.mimeTypeUsage(this.usage, action, mimeType).addFormParameters(new ParameterChecker(this.requestViolations).checkListParameters(formParameters, values, new Message("formParam", this.locator)));
    }

    private void checkQueryParameters(Values values, Action action, SecurityExtractor security) {
        UsageBuilder.actionUsage(this.usage, action).addQueryParameters(new ParameterChecker(this.requestViolations).checkParameters(action.getQueryParameters(), security.queryParameters(), values, new Message("queryParam", this.locator)));
    }

    private void checkRequestHeaderParameters(Values values, Action action, SecurityExtractor security) {
        UsageBuilder.actionUsage(this.usage, action).addRequestHeaders(new ParameterChecker(this.requestViolations).acceptWildcard().ignoreX(this.config.ignoreXheaders).caseSensitive(false).predefined(DefaultHeaders.REQUEST).checkParameters(action.getHeaders(), security.headers(), values, new Message("headerParam", this.locator)));
    }

    private void checkBaseUriParameters(VariableMatcher hostMatch, VariableMatcher pathMatch, Action action) {
        ParameterChecker paramChecker = new ParameterChecker(this.requestViolations).acceptUndefined();
        Map<String, List<? extends AbstractParam>> baseUriParams = CheckerHelper.getEffectiveBaseUriParams(this.config.raml.getBaseUriParameters(), action);
        paramChecker.checkListParameters(baseUriParams, hostMatch.getVariables(), new Message("baseUriParam", this.locator));
        paramChecker.checkListParameters(baseUriParams, pathMatch.getVariables(), new Message("baseUriParam", this.locator));
    }

    private VariableMatcher getPathMatch(UriComponents requestUri, UriComponents ramlUri) {
        VariableMatcher pathMatch = VariableMatcher.match(ramlUri.getPath(), requestUri.getPath());
        if (!pathMatch.isMatch()) {
            this.requestViolations.add("baseUri.unmatched", requestUri.getUri(), this.config.raml.getBaseUri());
            throw new RamlViolationException();
        }
        return pathMatch;
    }

    private VariableMatcher getHostMatch(UriComponents requestUri, UriComponents ramlUri) {
        VariableMatcher hostMatch = VariableMatcher.match(ramlUri.getHost(), requestUri.getHost());
        if (!hostMatch.isCompleteMatch()) {
            this.requestViolations.add("baseUri.unmatched", requestUri.getUri(), this.config.raml.getBaseUri());
            throw new RamlViolationException();
        }
        return hostMatch;
    }

    private void checkProtocol(Action action, UriComponents requestUri, UriComponents ramlUri) {
        List<Protocol> protocols = this.findProtocols(action, ramlUri.getScheme());
        this.requestViolations.addIf(!protocols.contains(CheckerHelper.protocolOf(requestUri.getScheme())), "protocol.undefined", this.locator, requestUri.getScheme());
    }

    private List<Protocol> findProtocols(Action action, String fallback) {
        List<Protocol> protocols = action.getProtocols();
        if (protocols == null || protocols.isEmpty()) {
            protocols = this.config.raml.getProtocols();
        }
        if (protocols == null || protocols.isEmpty()) {
            protocols = Collections.singletonList(Protocol.valueOf((String)fallback.toUpperCase()));
        }
        return protocols;
    }

    private void checkUriParams(Values values, Resource resource) {
        ParameterChecker paramChecker = new ParameterChecker(this.requestViolations).acceptUndefined();
        for (Map.Entry<String, List<Object>> entry : values) {
            AbstractParam uriParam = CheckerHelper.findUriParam(entry.getKey(), resource);
            Message message = new Message("uriParam", this.locator, entry.getKey());
            if (uriParam == null) continue;
            paramChecker.checkParameter(uriParam, entry.getValue().get(0), message);
        }
    }

    public MediaTypeMatch checkResponse(RamlResponse response, Action action, SecurityExtractor security) {
        Response res = CheckerHelper.findResponse(action, response.getStatus(), security);
        if (res == null) {
            this.responseViolations.add("responseCode.undefined", this.locator, response.getStatus());
            throw new RamlViolationException();
        }
        UsageBuilder.actionUsage(this.usage, action).addResponseCode("" + response.getStatus());
        this.locator.responseCode("" + response.getStatus());
        this.checkResponseHeaderParameters(response.getHeaderValues(), action, "" + response.getStatus(), res);
        MediaTypeMatch typeMatch = MediaTypeMatch.find(this.responseViolations, response, res.getBody(), this.locator);
        if (typeMatch != null) {
            this.locator.responseMime(typeMatch.getMatchingMime());
            this.checkSchema(this.responseViolations, response.getContent(), typeMatch);
        }
        return typeMatch;
    }

    private void checkSchema(RamlViolations violations, byte[] body, MediaTypeMatch typeMatch) {
        String schema = typeMatch.getMatchingMime().getSchema();
        if (schema == null) {
            return;
        }
        SchemaValidator validator = CheckerHelper.findSchemaValidator(this.config.schemaValidators, typeMatch.getTargetType());
        if (validator == null) {
            violations.add("schemaValidator.missing", this.locator, typeMatch.getTargetType());
            return;
        }
        if (body == null || body.length == 0) {
            violations.add("body.empty", this.locator, typeMatch.getTargetType());
            return;
        }
        String charset = typeMatch.getTargetCharset();
        try {
            String content = new String(body, charset);
            validator.validate(new NamedReader(content, new Message("body", new Object[0]).toString()), CheckerHelper.resolveSchema(this.config.raml, schema), violations, new Message("schema.body.mismatch", this.locator, content));
        }
        catch (UnsupportedEncodingException e) {
            violations.add("charset.invalid", charset);
        }
    }

    private void checkResponseHeaderParameters(Values values, Action action, String responseCode, Response response) {
        UsageBuilder.responseUsage(this.usage, action, responseCode).addResponseHeaders(new ParameterChecker(this.responseViolations).acceptWildcard().ignoreX(this.config.ignoreXheaders).caseSensitive(false).predefined(DefaultHeaders.RESPONSE).checkParameters(response.getHeaders(), values, new Message("headerParam", this.locator)));
    }

    private static final class DefaultHeaders {
        private static final Set<String> REQUEST = new HashSet<String>(Arrays.asList("accept", "accept-charset", "accept-encoding", "accept-language", "accept-datetime", "authorization", "cache-control", "connection", "cookie", "content-length", "content-md5", "content-type", "date", "dnt", "expect", "from", "host", "if-match", "if-modified-since", "if-none-match", "if-range", "if-unmodified-since", "max-forwards", "origin", "pragma", "proxy-authorization", "range", "referer", "te", "user-agent", "upgrade", "via", "warning"));
        private static final Set<String> RESPONSE = new HashSet<String>(Arrays.asList("access-control-allow-origin", "accept-ranges", "age", "allow", "cache-control", "connection", "content-encoding", "content-language", "content-length", "content-location", "content-md5", "content-disposition", "content-range", "content-type", "date", "etag", "expires", "last-modified", "link", "location", "p3p", "pragma", "proxy-authenticate", "refresh", "retry-after", "server", "set-cookie", "status", "strict-transport-security", "trailer", "transfer-encoding", "upgrade", "vary", "via", "warning", "www-authenticate", "x-frame-options"));

        private DefaultHeaders() {
        }
    }
}

