/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SecuritySchemeType;
import guru.nidi.ramltester.util.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.Raml;
import org.raml.model.Response;
import org.raml.model.SecurityReference;
import org.raml.model.SecurityScheme;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;

class SecurityExtractor {
    private final Raml raml;
    private final List<SecurityScheme> schemes;

    public SecurityExtractor(Raml raml, Action action, RamlViolations violations) {
        this.raml = raml;
        this.schemes = new SchemeFinder(raml, violations).securedBy(action);
    }

    public void check(RamlViolations violations) {
        for (Map schemeMap : this.raml.getSecuritySchemes()) {
            for (SecurityScheme scheme : schemeMap.values()) {
                SecuritySchemeType type = SecuritySchemeType.byName(scheme.getType());
                if (type == null) continue;
                type.check(scheme, violations);
            }
        }
    }

    public List<Map<String, QueryParameter>> queryParameters() {
        RemovePropagatingList<Map<String, QueryParameter>> res = new RemovePropagatingList<Map<String, QueryParameter>>();
        for (SecurityScheme scheme : this.schemes) {
            if (scheme.getDescribedBy() == null) continue;
            res.add(scheme.getDescribedBy().getQueryParameters());
        }
        return res;
    }

    public List<Map<String, Header>> headers() {
        RemovePropagatingList<Map<String, Header>> res = new RemovePropagatingList<Map<String, Header>>();
        for (SecurityScheme scheme : this.schemes) {
            if (scheme.getDescribedBy() == null) continue;
            res.add(scheme.getDescribedBy().getHeaders());
        }
        return res;
    }

    public List<Map<String, Response>> responses() {
        RemovePropagatingList<Map<String, Response>> res = new RemovePropagatingList<Map<String, Response>>();
        for (SecurityScheme scheme : this.schemes) {
            if (scheme.getDescribedBy() == null) continue;
            res.add(scheme.getDescribedBy().getResponses());
        }
        return res;
    }

    private static final class SchemeFinder {
        private final Raml raml;
        private final RamlViolations violations;

        public SchemeFinder(Raml raml, RamlViolations violations) {
            this.raml = raml;
            this.violations = violations;
        }

        public List<SecurityScheme> securedBy(Action action) {
            ArrayList<SecurityScheme> res = new ArrayList<SecurityScheme>();
            if (!action.getSecuredBy().isEmpty()) {
                res.addAll(this.securitySchemes(action.getSecuredBy(), new Message("securityScheme.undefined", new Locator(action))));
            } else if (!action.getResource().getSecuredBy().isEmpty()) {
                res.addAll(this.securitySchemes(action.getResource().getSecuredBy(), new Message("securityScheme.undefined", new Locator(action.getResource()))));
            } else if (!this.raml.getSecuredBy().isEmpty()) {
                res.addAll(this.securitySchemes(this.raml.getSecuredBy(), new Message("securityScheme.undefined", new Locator())));
            }
            return res;
        }

        private List<SecurityScheme> securitySchemes(List<SecurityReference> refs, Message message) {
            ArrayList<SecurityScheme> res = new ArrayList<SecurityScheme>();
            for (SecurityReference ref : refs) {
                String name = ref.getName();
                SecurityScheme ss = this.securityScheme(name);
                if (ss == null) {
                    this.violations.addIf(!name.equals("null"), message.withParam(name));
                    continue;
                }
                res.add(ss);
            }
            return res;
        }

        private SecurityScheme securityScheme(String name) {
            for (Map map : this.raml.getSecuritySchemes()) {
                if (!map.containsKey(name)) continue;
                return (SecurityScheme)map.get(name);
            }
            return null;
        }
    }

    private class RemovePropagatingList<T>
    extends ArrayList<T> {
        private RemovePropagatingList() {
        }

        @Override
        public T remove(int index) {
            Object removed = super.remove(index);
            SecurityExtractor.this.schemes.remove(index);
            return (T)removed;
        }
    }
}

