/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class SavingOutputStream
extends OutputStream {
    private final OutputStream delegate;
    private final ByteArrayOutputStream saved;

    public SavingOutputStream(OutputStream delegate) {
        this.delegate = delegate;
        this.saved = new ByteArrayOutputStream();
    }

    public byte[] getSaved() {
        return this.saved.toByteArray();
    }

    @Override
    public void write(int b) throws IOException {
        IOException e1 = null;
        IOException e2 = null;
        try {
            this.delegate.write(b);
        }
        catch (IOException e) {
            e1 = e;
        }
        this.saved.write(b);
        this.throwIfNeeded(e1, e2);
    }

    @Override
    public void write(byte[] b) throws IOException {
        IOException e1 = null;
        IOException e2 = null;
        try {
            this.delegate.write(b);
        }
        catch (IOException e) {
            e1 = e;
        }
        try {
            this.saved.write(b);
        }
        catch (IOException e) {
            e2 = e;
        }
        this.throwIfNeeded(e1, e2);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        IOException e1 = null;
        IOException e2 = null;
        try {
            this.delegate.write(b, off, len);
        }
        catch (IOException e) {
            e1 = e;
        }
        this.saved.write(b, off, len);
        this.throwIfNeeded(e1, e2);
    }

    @Override
    public void flush() throws IOException {
        IOException e1 = null;
        IOException e2 = null;
        try {
            this.delegate.flush();
        }
        catch (IOException e) {
            e1 = e;
        }
        try {
            this.saved.flush();
        }
        catch (IOException e) {
            e2 = e;
        }
        this.throwIfNeeded(e1, e2);
    }

    @Override
    public void close() throws IOException {
        IOException e1 = null;
        IOException e2 = null;
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            e1 = e;
        }
        try {
            this.saved.close();
        }
        catch (IOException e) {
            e2 = e;
        }
        this.throwIfNeeded(e1, e2);
    }

    private void throwIfNeeded(IOException e1, IOException e2) throws IOException {
        if (e1 != null) {
            throw e1;
        }
        if (e2 != null) {
            throw e2;
        }
    }
}

