/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.spring;

import guru.nidi.ramltester.core.DummyReportAggragator;
import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportAggregator;
import guru.nidi.ramltester.spring.SpringMockRamlRequest;
import guru.nidi.ramltester.spring.SpringMockRamlResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class RamlMatcher
implements ResultMatcher {
    private final RamlChecker checker;
    private final ReportAggregator aggregator;

    private RamlMatcher(RamlChecker checker, ReportAggregator aggregator) {
        this.checker = checker;
        this.aggregator = aggregator;
    }

    public RamlMatcher(RamlChecker checker) {
        this(checker, new DummyReportAggragator());
    }

    public RamlMatcher aggregating(ReportAggregator aggregator) {
        return new RamlMatcher(this.checker, aggregator);
    }

    public void match(MvcResult result) throws Exception {
        RamlReport report = this.testAgainst(result);
        if (!report.isEmpty()) {
            throw new AssertionError((Object)report.toString());
        }
    }

    public RamlReport testAgainst(MvcResult result) {
        return this.aggregator.addReport(this.checker.check(new SpringMockRamlRequest(result.getRequest()), new SpringMockRamlResponse(result.getResponse())));
    }
}

