/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.spring;

import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.spring.SpringHttpRamlMessage;
import guru.nidi.ramltester.util.FormDecoder;
import guru.nidi.ramltester.util.UriComponents;
import org.springframework.http.HttpRequest;

public class SpringHttpRamlRequest
extends SpringHttpRamlMessage
implements RamlRequest {
    private final HttpRequest request;
    private final byte[] body;
    private final UriComponents uriComponents;

    public SpringHttpRamlRequest(HttpRequest request, byte[] body) {
        this.request = request;
        this.body = body;
        this.uriComponents = UriComponents.fromHttpUrl(request.getURI().toString());
    }

    @Override
    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        return (baseUri != null ? baseUri : this.uriComponents.getServer()) + this.uriComponents.getPath();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod().name();
    }

    @Override
    public Values getQueryValues() {
        return this.uriComponents.getQueryParameters();
    }

    @Override
    public Values getFormValues() {
        return new FormDecoder().decode(this);
    }

    @Override
    public Values getHeaderValues() {
        return this.headerValuesOf(this.request.getHeaders());
    }

    @Override
    public String getContentType() {
        return this.contentTypeOf(this.request.getHeaders());
    }

    @Override
    public byte[] getContent() {
        return this.body;
    }
}

