/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.spring;

import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.FileValue;
import guru.nidi.ramltester.util.IoUtils;
import guru.nidi.ramltester.util.UriComponents;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriUtils;

public class SpringMockRamlRequest
implements RamlRequest {
    private final MockHttpServletRequest delegate;

    public SpringMockRamlRequest(MockHttpServletRequest delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        return baseUri != null ? baseUri + this.delegate.getPathInfo() : this.delegate.getRequestURL().toString();
    }

    @Override
    public String getMethod() {
        return this.delegate.getMethod();
    }

    @Override
    public Values getQueryValues() {
        String q = this.delegate.getQueryString();
        try {
            return UriComponents.parseQuery(q == null ? null : UriUtils.decode((String)q, (String)"utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Cannot happen");
        }
    }

    @Override
    public Values getFormValues() {
        Values values = new Values(this.delegate.getParameterMap());
        if (this.delegate instanceof MockMultipartHttpServletRequest) {
            for (Map.Entry entry : ((MockMultipartHttpServletRequest)this.delegate).getMultiFileMap().entrySet()) {
                for (MultipartFile file : (List)entry.getValue()) {
                    values.addValue((String)entry.getKey(), new FileValue());
                }
            }
        }
        return values;
    }

    @Override
    public Values getHeaderValues() {
        Values headers = new Values();
        Enumeration names = this.delegate.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = this.delegate.getHeaders(name);
            while (values.hasMoreElements()) {
                headers.addValue(name, values.nextElement());
            }
        }
        return headers;
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public byte[] getContent() {
        try {
            return IoUtils.readIntoByteArray((InputStream)this.delegate.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read request body", e);
        }
    }
}

