/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.util;

import guru.nidi.ramltester.util.InvalidMediaTypeException;
import guru.nidi.ramltester.util.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class MediaType {
    public static final Comparator<MediaType> QUALITY_COMPARATOR = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType m1, MediaType m2) {
            double diff = m2.getQualityParameter() - m1.getQualityParameter();
            return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
        }
    };
    public static final MediaType JSON = MediaType.valueOf("application/json");
    public static final MediaType FORM_URL_ENCODED = MediaType.valueOf("application/x-www-form-urlencoded");
    public static final MediaType MULTIPART = MediaType.valueOf("multipart/form-data");
    private static final String CHARSET = "charset";
    private static final String WILDCARD_TYPE = "*";
    private static final Map<String, MediaType> KNOWN_SUFFICES = new HashMap<String, MediaType>(){
        {
            this.put("json", JSON);
        }
    };
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    private MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    public static MediaType valueOf(String mimeType) {
        int subIndex;
        if (mimeType == null || mimeType.length() == 0) {
            throw new InvalidMediaTypeException(mimeType, new Message("mediaType.empty", new Object[0]));
        }
        String[] parts = MediaType.tokenizeToStringArray(mimeType, ";");
        String fullType = parts[0].trim();
        if (WILDCARD_TYPE.equals(fullType)) {
            fullType = "*/*";
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new InvalidMediaTypeException(mimeType, new Message("mediaType.noSlash", new Object[0]));
        }
        if (subIndex == fullType.length() - 1) {
            throw new InvalidMediaTypeException(mimeType, new Message("mediaType.noSubtype", new Object[0]));
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1, fullType.length());
        if (WILDCARD_TYPE.equals(type) && !WILDCARD_TYPE.equals(subtype)) {
            throw new InvalidMediaTypeException(mimeType, new Message("mediaType.wildcard.illegal", new Object[0]));
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(parts.length);
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                String parameter = parts[i];
                int eqIndex = parameter.indexOf(61);
                if (eqIndex == -1) continue;
                String attribute = parameter.substring(0, eqIndex);
                String value = parameter.substring(eqIndex + 1, parameter.length());
                parameters.put(attribute, value);
            }
        }
        for (Map.Entry entry : parameters.entrySet()) {
            MediaType.checkParameter(mimeType, (String)entry.getKey(), (String)entry.getValue());
        }
        return new MediaType(type, subtype, parameters);
    }

    public double getQualityParameter() {
        String q = this.getParameter("q");
        return q == null ? 1.0 : Double.parseDouble(q);
    }

    private static void checkParameter(String mimeType, String key, String value) {
        if ("q".equals(key)) {
            value = MediaType.unquote(value);
            try {
                double d = Double.parseDouble(value);
                if (d < 0.0 || d > 1.0) {
                    throw new InvalidMediaTypeException(mimeType, new Message("mediaType.quality.illegal", value));
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidMediaTypeException(mimeType, new Message("mediaType.quality.illegal", value));
            }
        }
    }

    private static boolean isQuotedString(String s) {
        return s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"));
    }

    private static String unquote(String s) {
        if (s == null) {
            return null;
        }
        return MediaType.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
    }

    public boolean isWildcardType() {
        return WILDCARD_TYPE.equals(this.getType());
    }

    public boolean isWildcardSubtype() {
        return WILDCARD_TYPE.equals(this.getSubtype()) || this.getSubtype().startsWith("*+");
    }

    public int similarity(MediaType other) {
        if (this.getType().equals(other.getType())) {
            if (this.getSubtype().equals(other.getSubtype())) {
                return this.getParameters().equals(other.getParameters()) ? 4 : 3;
            }
            if (this.isWildcardSubtype() || other.isWildcardSubtype()) {
                String thisSuffix = this.findSuffix();
                String otherSuffix = other.findSuffix();
                if (thisSuffix == null && otherSuffix == null || thisSuffix != null && thisSuffix.equals(otherSuffix)) {
                    return 2;
                }
                return 0;
            }
        }
        if (this.isWildcardType() || other.isWildcardType()) {
            return 1;
        }
        MediaType thisKnown = this.applyKnownSuffices();
        MediaType otherKnown = other.applyKnownSuffices();
        if (thisKnown != this || otherKnown != other) {
            return thisKnown.similarity(otherKnown);
        }
        return 0;
    }

    public boolean isCompatibleWith(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType() || other.isWildcardType()) {
            return true;
        }
        MediaType thisKnown = this.applyKnownSuffices();
        MediaType otherKnown = other.applyKnownSuffices();
        if ((thisKnown != this || otherKnown != other) && thisKnown.isCompatibleWith(otherKnown)) {
            return true;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (this.getSubtype().equals(other.getSubtype())) {
            return true;
        }
        if (this.isWildcardSubtype() || other.isWildcardSubtype()) {
            String thisSuffix = this.findSuffix();
            String otherSuffix = other.findSuffix();
            if (thisSuffix == null && otherSuffix == null || thisSuffix != null && thisSuffix.equals(otherSuffix)) {
                return true;
            }
        }
        return false;
    }

    private MediaType applyKnownSuffices() {
        MediaType known = KNOWN_SUFFICES.get(this.findSuffix());
        return known == null ? this : known;
    }

    private String findSuffix() {
        int pos = this.getSubtype().indexOf(43);
        return pos == -1 ? null : this.getSubtype().substring(pos + 1);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String getCharset(String defaultCharset) {
        String charset = this.parameters.get(CHARSET);
        return charset == null ? defaultCharset : charset;
    }

    private static String[] tokenizeToStringArray(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = token.trim()).length() <= 0) continue;
            tokens.add(token);
        }
        return MediaType.toStringArray(tokens);
    }

    private static String[] toStringArray(Collection<String> collection) {
        return collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaType)) {
            return false;
        }
        MediaType otherType = (MediaType)other;
        return this.type.equalsIgnoreCase(otherType.type) && this.subtype.equalsIgnoreCase(otherType.subtype) && this.parameters.equals(otherType.parameters);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        String res = this.type + "/" + this.subtype;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            res = res + ";" + entry.getKey() + "=" + entry.getValue();
        }
        return res;
    }
}

