/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester;

import guru.nidi.loader.Loader;
import guru.nidi.loader.apidesigner.ApiLoader;
import guru.nidi.loader.basic.ClassPathLoader;
import guru.nidi.loader.basic.CompositeLoader;
import guru.nidi.loader.basic.FileLoader;
import guru.nidi.loader.basic.UriLoader;
import guru.nidi.loader.url.GithubLoader;
import guru.nidi.loader.url.UrlLoader;
import guru.nidi.loader.use.raml.LoaderRamlResourceLoader;
import guru.nidi.loader.use.raml.RamlCache;
import guru.nidi.ramltester.RamlDefinition;
import guru.nidi.ramltester.RelativeJsonSchemaAwareRamlDocumentBuilder;
import guru.nidi.ramltester.SchemaValidators;
import guru.nidi.ramltester.core.SchemaValidator;
import java.io.File;
import org.raml.model.Raml;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.TagResolver;

public class RamlLoaders {
    private final Loader loader;
    private final SchemaValidators schemaValidators;
    private final boolean caching;

    public RamlLoaders(Loader loader, SchemaValidators schemaValidators, boolean caching) {
        this.loader = loader;
        this.schemaValidators = schemaValidators;
        this.caching = caching;
    }

    private static Loader classpathLoader(Class<?> basePackage) {
        return RamlLoaders.classpathLoader(basePackage.getPackage().getName().replace('.', '/'));
    }

    private static Loader classpathLoader(String basePackage) {
        return new ClassPathLoader(basePackage);
    }

    private static Loader fileLoader(File baseDirectory) {
        return new FileLoader(baseDirectory);
    }

    private static Loader fileLoader(String baseDirectory) {
        return new FileLoader(new File(baseDirectory));
    }

    private static Loader urlLoader(String baseUrl) {
        return new UrlLoader(baseUrl);
    }

    private static Loader githubLoader(String token, String project) {
        return new GithubLoader(token, project);
    }

    private static Loader apiPortalLoader(String user, String password) {
        return new ApiLoader(user, password);
    }

    private static Loader apiDesignerLoader(String url) {
        return new ApiLoader(url);
    }

    public static RamlLoaders fromClasspath(Class<?> basePackage) {
        return RamlLoaders.using(RamlLoaders.classpathLoader(basePackage));
    }

    public static RamlLoaders fromClasspath(String basePackage) {
        return RamlLoaders.using(RamlLoaders.classpathLoader(basePackage));
    }

    public static RamlLoaders fromClasspath() {
        return RamlLoaders.using(RamlLoaders.classpathLoader(""));
    }

    public static RamlLoaders fromFile(File baseDirectory) {
        return RamlLoaders.using(RamlLoaders.fileLoader(baseDirectory));
    }

    public static RamlLoaders fromFile(String baseDirectory) {
        return RamlLoaders.using(RamlLoaders.fileLoader(baseDirectory));
    }

    public static RamlLoaders fromUrl(String baseUrl) {
        return RamlLoaders.using(RamlLoaders.urlLoader(baseUrl));
    }

    public static RamlLoaders fromGithub(String project) {
        return RamlLoaders.fromGithub(null, project);
    }

    public static RamlLoaders fromGithub(String token, String project) {
        return RamlLoaders.using(RamlLoaders.githubLoader(token, project));
    }

    public static RamlLoaders fromApiPortal(String user, String password) {
        return RamlLoaders.using(RamlLoaders.apiPortalLoader(user, password));
    }

    public static RamlLoaders fromApiDesigner(String url) {
        return RamlLoaders.using(RamlLoaders.apiDesignerLoader(url));
    }

    public static RamlLoaders absolutely() {
        return RamlLoaders.using(null);
    }

    public static RamlLoaders using(Loader loader) {
        return new RamlLoaders(loader, SchemaValidators.standard(), false);
    }

    public RamlLoaders andFromClasspath(Class<?> basePackage) {
        return this.andUsing(RamlLoaders.classpathLoader(basePackage));
    }

    public RamlLoaders andFromClasspath(String basePackage) {
        return this.andUsing(RamlLoaders.classpathLoader(basePackage));
    }

    public RamlLoaders andFromFile(File baseDirectory) {
        return this.andUsing(RamlLoaders.fileLoader(baseDirectory));
    }

    public RamlLoaders andFromFile(String baseDirectory) {
        return this.andUsing(RamlLoaders.fileLoader(baseDirectory));
    }

    public RamlLoaders andFromUrl(String baseUrl) {
        return this.andUsing(RamlLoaders.urlLoader(baseUrl));
    }

    public RamlLoaders andFromGithub(String project) {
        return this.andFromGithub(null, project);
    }

    public RamlLoaders andFromGithub(String token, String project) {
        return this.andUsing(RamlLoaders.githubLoader(token, project));
    }

    public RamlLoaders andFromApiPortal(String user, String password) {
        return this.andUsing(RamlLoaders.apiPortalLoader(user, password));
    }

    public RamlLoaders andFromApiDesigner(String url) {
        return this.andUsing(RamlLoaders.apiDesignerLoader(url));
    }

    public RamlLoaders andUsing(Loader loader) {
        return new RamlLoaders((Loader)new CompositeLoader(new Loader[]{this.loader, loader}), this.schemaValidators, this.caching);
    }

    public RamlLoaders addSchemaValidator(SchemaValidator schemaValidator) {
        return new RamlLoaders(this.loader, this.schemaValidators.addSchemaValidator(schemaValidator), this.caching);
    }

    public RamlDefinition load(String name) {
        UriLoader decorated = new UriLoader(this.loader);
        Raml raml = this.caching ? new RamlCache((Loader)decorated).loadRaml(name) : (Raml)new RelativeJsonSchemaAwareRamlDocumentBuilder((Loader)decorated, (ResourceLoader)new LoaderRamlResourceLoader((Loader)decorated), new TagResolver[0]).build(name);
        SchemaValidators validators = this.schemaValidators.withloader((Loader)decorated);
        return new RamlDefinition(raml, validators);
    }
}

