/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester;

import com.fasterxml.jackson.databind.ObjectMapper;
import guru.nidi.loader.Loader;
import java.io.IOException;
import java.util.Map;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.TupleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

class RelativeJsonSchemaAwareRamlDocumentBuilder
extends RamlDocumentBuilder {
    private static final Logger log = LoggerFactory.getLogger(RelativeJsonSchemaAwareRamlDocumentBuilder.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final String protocol;
    private NodeTuple schemaTuple;

    public RelativeJsonSchemaAwareRamlDocumentBuilder(Loader loader, ResourceLoader resourceLoader, TagResolver ... tagResolvers) {
        super(resourceLoader, tagResolvers);
        this.protocol = loader.getClass().getSimpleName();
    }

    public boolean onTupleStart(NodeTuple nodeTuple) {
        String name;
        Node keyNode = nodeTuple.getKeyNode();
        if (keyNode instanceof ScalarNode && ("schema".equals(name = ((ScalarNode)keyNode).getValue()) || "schemas".equals(name))) {
            if (this.schemaTuple == null) {
                this.schemaTuple = nodeTuple;
            } else {
                log.warn("Internal error. Nested schema nodes.");
            }
        }
        return super.onTupleStart(nodeTuple);
    }

    public void onTupleEnd(NodeTuple nodeTuple) {
        if (nodeTuple == this.schemaTuple) {
            this.schemaTuple = null;
        }
        super.onTupleEnd(nodeTuple);
    }

    public void onScalar(ScalarNode node, TupleType tupleType) {
        String includeName;
        if (this.schemaTuple != null && node instanceof IncludeResolver.IncludeScalarNode && (includeName = ((IncludeResolver.IncludeScalarNode)node).getIncludeName()).endsWith(".json")) {
            try {
                Map json = (Map)this.mapper.readValue(node.getValue(), Map.class);
                if (json.containsKey("$schema") && !json.containsKey("id")) {
                    json.put("id", this.protocol + ":/" + includeName);
                    super.onScalar(new ScalarNode(node.getTag(), node.isResolved(), this.mapper.writeValueAsString((Object)json), node.getStartMark(), node.getEndMark(), node.getStyle()), tupleType);
                    return;
                }
            }
            catch (IOException e) {
                log.warn("Line {}: Could not parse json file '{}' as schema. Relative $refs inside might not work: {}", new Object[]{node.getStartMark().getLine() + 1, includeName, e.getMessage()});
            }
        }
        super.onScalar(node, tupleType);
    }
}

