/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.NamedReader;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.core.VariableMatcher;
import guru.nidi.ramltester.model.RamlMessage;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Protocol;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.UriParameter;

final class CheckerHelper {
    private CheckerHelper() {
    }

    public static Protocol protocolOf(String s) {
        if ("http".equalsIgnoreCase(s)) {
            return Protocol.HTTP;
        }
        if ("https".equalsIgnoreCase(s)) {
            return Protocol.HTTPS;
        }
        return null;
    }

    public static boolean isNoOrEmptyBodies(Map<String, MimeType> bodies) {
        return bodies == null || bodies.isEmpty() || bodies.size() == 1 && bodies.containsKey(null);
    }

    public static boolean hasContent(RamlMessage message) {
        return message.getContent() != null && message.getContent().length > 0;
    }

    public static boolean existSchemalessBody(Map<String, MimeType> bodies) {
        for (MimeType mimeType : bodies.values()) {
            if (mimeType.getSchema() != null) continue;
            return true;
        }
        return false;
    }

    public static AbstractParam findUriParam(String uriParam, Resource resource) {
        UriParameter param = (UriParameter)resource.getUriParameters().get(uriParam);
        if (param != null) {
            return param;
        }
        if (resource.getParentResource() != null) {
            return CheckerHelper.findUriParam(uriParam, resource.getParentResource());
        }
        return null;
    }

    public static Resource findResource(String resourcePath, Map<String, Resource> resources, Values values) {
        ArrayList<ResourceMatch> matches = new ArrayList<ResourceMatch>();
        for (Map.Entry<String, Resource> entry : resources.entrySet()) {
            VariableMatcher pathMatch = VariableMatcher.match(entry.getKey(), resourcePath);
            if (!pathMatch.isCompleteMatch() && (!pathMatch.isMatch() || !pathMatch.getSuffix().startsWith("/"))) continue;
            matches.add(new ResourceMatch(pathMatch, entry.getValue()));
        }
        Collections.sort(matches);
        for (ResourceMatch match : matches) {
            if (match.match.isCompleteMatch()) {
                values.addValues(match.match.getVariables());
                return match.resource;
            }
            if (!match.match.isMatch()) continue;
            values.addValues(match.match.getVariables());
            return CheckerHelper.findResource(match.match.getSuffix(), match.resource.getResources(), values);
        }
        return null;
    }

    public static SchemaValidator findSchemaValidator(List<SchemaValidator> validators, MediaType mediaType) {
        for (SchemaValidator validator : validators) {
            if (!validator.supports(mediaType)) continue;
            return validator;
        }
        return null;
    }

    public static Map<String, List<? extends AbstractParam>> getEffectiveBaseUriParams(Map<String, UriParameter> baseUriParams, Action action) {
        HashMap<String, List<? extends AbstractParam>> params = new HashMap<String, List<? extends AbstractParam>>();
        if (action.getBaseUriParameters() != null) {
            params.putAll(action.getBaseUriParameters());
        }
        CheckerHelper.addNotSetBaseUriParams(action.getResource(), params);
        if (baseUriParams != null) {
            for (Map.Entry<String, UriParameter> entry : baseUriParams.entrySet()) {
                if (params.containsKey(entry.getKey())) continue;
                params.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
        return params;
    }

    private static void addNotSetBaseUriParams(Resource resource, Map<String, List<? extends AbstractParam>> params) {
        if (resource.getBaseUriParameters() != null) {
            for (Map.Entry entry : resource.getBaseUriParameters().entrySet()) {
                if (params.containsKey(entry.getKey())) continue;
                params.put((String)entry.getKey(), (List<? extends AbstractParam>)entry.getValue());
            }
        }
        if (resource.getParentResource() != null) {
            CheckerHelper.addNotSetBaseUriParams(resource.getParentResource(), params);
        }
    }

    public static Collection<Map.Entry<String, AbstractParam>> paramEntries(Map<String, ?> params) {
        ArrayList<Map.Entry<String, AbstractParam>> res = new ArrayList<Map.Entry<String, AbstractParam>>();
        for (Map.Entry<String, ?> param : params.entrySet()) {
            if (param.getValue() instanceof List) {
                for (AbstractParam p : (List)param.getValue()) {
                    res.add(new AbstractMap.SimpleEntry<String, AbstractParam>(param.getKey(), p));
                }
                continue;
            }
            res.add(param);
        }
        return res;
    }

    public static Reader resolveSchema(Raml raml, String schema) {
        String refSchema = (String)raml.getConsolidatedSchemas().get(schema);
        return refSchema == null ? new NamedReader(schema, new Message("schema.inline", new Object[0]).toString()) : new NamedReader(refSchema, new Message("schema", schema).toString());
    }

    public static <T> Map<String, T> mergeMaps(Map<String, T> map1, Map<String, T> map2) {
        HashMap<String, T> res = new HashMap<String, T>();
        res.putAll(map1);
        res.putAll(map2);
        return res;
    }

    private static final class ResourceMatch
    implements Comparable<ResourceMatch> {
        private final VariableMatcher match;
        private final Resource resource;

        public ResourceMatch(VariableMatcher match, Resource resource) {
            this.match = match;
            this.resource = resource;
        }

        @Override
        public int compareTo(ResourceMatch o) {
            return this.match.getVariables().size() - o.match.getVariables().size();
        }
    }
}

