/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.util.Message;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Resource;

final class Locator {
    private Resource resource;
    private Action action;
    private MimeType requestMime;
    private String responseCode;
    private MimeType responseMime;

    public Locator() {
    }

    public Locator(Resource resource) {
        this.resource(resource);
    }

    public Locator(Action action) {
        this.action(action);
    }

    public Locator(MimeType mimeType) {
        this.requestMime(mimeType);
    }

    public void resource(Resource resource) {
        this.resource = resource;
        this.action = null;
        this.requestMime = null;
        this.responseCode = null;
        this.responseMime = null;
    }

    public void action(Action action) {
        this.resource = action.getResource();
        this.action = action;
        this.requestMime = null;
        this.responseCode = null;
        this.responseMime = null;
    }

    public void requestMime(MimeType requestMime) {
        this.requestMime = requestMime;
        this.responseCode = null;
        this.responseMime = null;
    }

    public void responseCode(String responseCode) {
        this.responseCode = responseCode;
        this.requestMime = null;
        this.responseMime = null;
    }

    public void responseMime(MimeType responseMime) {
        this.responseMime = responseMime;
        this.requestMime = null;
    }

    public String toString() {
        if (this.responseCode != null) {
            return this.actionString() + " " + new Message("response", this.responseCode).toString() + (this.responseMime == null ? "" : " " + new Message("mimeType", this.responseMime.getType()).toString());
        }
        if (this.requestMime != null) {
            return (this.action == null ? "" : this.actionString() + " ") + new Message("mimeType", this.requestMime.getType()).toString();
        }
        if (this.action != null) {
            return this.actionString();
        }
        if (this.resource != null) {
            return new Message("resource", this.resource.getUri()).toString();
        }
        return new Message("root", new Object[0]).toString();
    }

    private String actionString() {
        return new Message("action", this.action.getType(), this.action.getResource().getUri()).toString();
    }
}

