/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.JsRegex;
import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.FileValue;
import guru.nidi.ramltester.util.Message;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.raml.model.ParamType;
import org.raml.model.parameter.AbstractParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParameterChecker {
    private static final Pattern INTEGER = Pattern.compile("0|-?[1-9][0-9]*");
    private static final Pattern NUMBER = Pattern.compile("0|inf|-inf|nan|-?(((0?|[1-9][0-9]*)\\.[0-9]*[1-9])|([1-9][0-9]*))(e[-+]?[1-9][0-9]*)?");
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String WILDCARD = "{?}";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RamlViolations violations;
    private final boolean acceptUndefined;
    private final boolean acceptWildcard;
    private final boolean ignoreX;
    private final boolean caseSensitive;
    private final Set<String> predefined;

    ParameterChecker(RamlViolations violations, boolean acceptUndefined, boolean acceptWildcard, boolean ignoreX, boolean caseSensitive, Set<String> predefined) {
        this.violations = violations;
        this.acceptUndefined = acceptUndefined;
        this.acceptWildcard = acceptWildcard;
        this.ignoreX = ignoreX;
        this.caseSensitive = caseSensitive;
        this.predefined = predefined;
    }

    ParameterChecker(RamlViolations violations) {
        this(violations, false, false, false, true, Collections.emptySet());
    }

    ParameterChecker acceptUndefined() {
        return new ParameterChecker(this.violations, true, this.acceptWildcard, this.ignoreX, this.caseSensitive, this.predefined);
    }

    ParameterChecker acceptWildcard() {
        return new ParameterChecker(this.violations, this.acceptUndefined, true, this.ignoreX, this.caseSensitive, this.predefined);
    }

    ParameterChecker ignoreX(boolean ignoreX) {
        return new ParameterChecker(this.violations, this.acceptUndefined, this.acceptWildcard, ignoreX, this.caseSensitive, this.predefined);
    }

    ParameterChecker caseSensitive(boolean caseSensitive) {
        return new ParameterChecker(this.violations, this.acceptUndefined, this.acceptWildcard, this.ignoreX, caseSensitive, this.predefined);
    }

    ParameterChecker predefined(Set<String> predefined) {
        return new ParameterChecker(this.violations, this.acceptUndefined, this.acceptWildcard, this.ignoreX, this.caseSensitive, predefined);
    }

    public Set<String> checkParameters(Map<String, ? extends AbstractParam> params, Values values, Message message) {
        HashMap<String, List<? extends AbstractParam>> listParams = new HashMap<String, List<? extends AbstractParam>>();
        this.addToMapOfList(params, listParams);
        return this.checkListParameters(listParams, values, message);
    }

    private void addToMapOfList(Map<String, ? extends AbstractParam> params, Map<String, List<? extends AbstractParam>> listParams) {
        for (Map.Entry<String, ? extends AbstractParam> entry : params.entrySet()) {
            listParams.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
    }

    private boolean acceptUndefined(String name) {
        return this.acceptUndefined || this.predefined.contains(name) || this.ignoreX && name.startsWith("x-");
    }

    public Set<String> checkListParameters(Map<String, List<? extends AbstractParam>> params, Values values, Message message) {
        Message namedMsg;
        HashSet<String> found = new HashSet<String>();
        for (Map.Entry<String, List<Object>> entry : values) {
            namedMsg = message.withParam(entry.getKey());
            String paramName = this.findMatchingParamName(params.keySet(), entry.getKey());
            List<? extends AbstractParam> list = params.get(paramName);
            if (list == null || list.isEmpty()) {
                this.violations.addIf(!this.acceptUndefined(entry.getKey().toLowerCase(Locale.ENGLISH)), namedMsg.withMessageParam("undefined", new Object[0]));
                continue;
            }
            for (AbstractParam abstractParam : list) {
                this.violations.addIf(!abstractParam.isRepeat() && entry.getValue().size() > 1, namedMsg.withMessageParam("repeat.superfluous", new Object[0]));
                for (Object value : entry.getValue()) {
                    this.checkParameter(abstractParam, value, namedMsg);
                }
            }
            found.add(paramName);
        }
        for (Map.Entry<String, List<Object>> entry : params.entrySet()) {
            namedMsg = message.withParam(entry.getKey());
            for (AbstractParam abstractParam : entry.getValue()) {
                this.violations.addIf(abstractParam.isRequired() && !found.contains(entry.getKey()), namedMsg.withMessageParam("required.missing", new Object[0]));
            }
        }
        return found;
    }

    private String findMatchingParamName(Collection<String> paramNames, String name) {
        String normalName = this.normalizeName(name);
        for (String param : paramNames) {
            String normalParam = this.normalizeName(param);
            int pos = normalParam.indexOf(WILDCARD);
            if (!normalParam.equals(normalName) && (!this.acceptWildcard || pos < 0 || !this.nameMatchesKeyStart(normalName, normalParam, pos) || !this.nameMatchesKeyEnd(normalName, normalParam, pos))) continue;
            return param;
        }
        return null;
    }

    private String normalizeName(String name) {
        return this.caseSensitive ? name : name.toLowerCase(Locale.ENGLISH);
    }

    private boolean nameMatchesKeyStart(String name, String key, int wildcardPos) {
        return wildcardPos == 0 || name.startsWith(key.substring(0, wildcardPos));
    }

    private boolean nameMatchesKeyEnd(String name, String key, int wildcardPos) {
        return wildcardPos == key.length() - WILDCARD.length() || name.endsWith(key.substring(wildcardPos + WILDCARD.length()));
    }

    public void checkParameter(AbstractParam param, Object value, Message message) {
        if (value == null) {
            Message detail = message.withInnerParam(new Message("value", "empty"));
            this.checkNullParameter(param, detail);
        } else {
            Message detail = message.withInnerParam(new Message("value", value));
            if (value instanceof String) {
                this.checkStringParameter(param, (String)value, detail);
            } else if (value instanceof FileValue) {
                this.checkFileParameter(param, detail);
            } else {
                throw new IllegalArgumentException("Unhandled parameter value '" + value + "' of type " + value.getClass());
            }
        }
    }

    private void checkNullParameter(AbstractParam param, Message detail) {
        if (param.getType() == ParamType.STRING) {
            this.checkStringParameter(param, "", detail);
        } else {
            this.violations.add(detail.withMessageParam("value.empty", new Object[0]));
        }
    }

    private void checkFileParameter(AbstractParam param, Message detail) {
        if (param.getType() != ParamType.FILE) {
            this.violations.add(detail.withMessageParam("file.superfluous", param.getType()));
        }
    }

    private void checkStringParameter(AbstractParam param, String value, Message detail) {
        switch (param.getType()) {
            case BOOLEAN: {
                this.checkBoolean(value, detail);
                break;
            }
            case DATE: {
                this.checkDate(value, detail);
                break;
            }
            case FILE: {
                this.checkFile(detail);
                break;
            }
            case INTEGER: {
                this.checkInteger(param, value, detail);
                break;
            }
            case NUMBER: {
                this.checkNumber(param, value, detail);
                break;
            }
            case STRING: {
                this.checkString(param, value, detail);
                break;
            }
            default: {
                throw new RamlCheckerException("Unhandled parameter type '" + param.getType() + "'");
            }
        }
    }

    private void checkString(AbstractParam param, String value, Message detail) {
        this.violations.addIf(param.getEnumeration() != null && !param.getEnumeration().contains(value), detail.withMessageParam("enum.invalid", param.getEnumeration()));
        try {
            this.violations.addIf(param.getPattern() != null && !JsRegex.matches(value, param.getPattern()), detail.withMessageParam("pattern.invalid", param.getPattern()));
        }
        catch (PatternSyntaxException e) {
            this.log.warn("Could not execute regex '" + param.getPattern(), (Throwable)e);
        }
        this.violations.addIf(param.getMinLength() != null && value.length() < param.getMinLength(), detail.withMessageParam("length.tooSmall", param.getMinLength()));
        this.violations.addIf(param.getMaxLength() != null && value.length() > param.getMaxLength(), detail.withMessageParam("length.tooBig", param.getMaxLength()));
    }

    private void checkNumber(AbstractParam param, String value, Message detail) {
        if (NUMBER.matcher(value).matches()) {
            if ("inf".equals(value) || "-inf".equals(value) || "nan".equals(value)) {
                this.violations.addIf(param.getMinimum() != null || param.getMaximum() != null, detail.withMessageParam("unbound", new Object[0]));
            } else {
                this.checkNumericLimits(param, new BigDecimal(value), detail);
            }
        } else {
            this.violations.add(detail.withMessageParam("number.invalid", new Object[0]));
        }
    }

    private void checkInteger(AbstractParam param, String value, Message detail) {
        if (INTEGER.matcher(value).matches()) {
            this.checkNumericLimits(param, new BigDecimal(value), detail);
        } else {
            this.violations.add(detail.withMessageParam("integer.invalid", new Object[0]));
        }
    }

    private void checkFile(Message detail) {
        this.violations.add(detail.withMessageParam("file.invalid", new Object[0]));
    }

    private void checkDate(String value, Message detail) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
            dateFormat.setLenient(false);
            dateFormat.parse(value);
        }
        catch (ParseException e) {
            this.violations.add(detail.withMessageParam("date.invalid", new Object[0]));
        }
    }

    private void checkBoolean(String value, Message detail) {
        this.violations.addIf(!"true".equals(value) && !"false".equals(value), detail.withMessageParam("boolean.invalid", new Object[0]));
    }

    private void checkNumericLimits(AbstractParam param, BigDecimal value, Message message) {
        this.violations.addIf(param.getMinimum() != null && param.getMinimum().compareTo(value) > 0, message.withMessageParam("value.tooSmall", param.getMinimum()));
        this.violations.addIf(param.getMaximum() != null && param.getMaximum().compareTo(value) < 0, message.withMessageParam("value.tooBig", param.getMaximum()));
    }
}

