/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CheckerHelper;
import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.NamedReader;
import guru.nidi.ramltester.core.ParameterChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.core.Validation;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.raml.model.Action;
import org.raml.model.DocumentationItem;
import org.raml.model.MimeType;
import org.raml.model.ParamType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.AbstractParam;

class RamlValidatorChecker {
    private static final String PARAM_CONDITION_ILLEGAL = "parameter.condition.illegal";
    private final Raml raml;
    private final Locator locator;
    private final Pattern resourcePattern;
    private final Pattern parameterPattern;
    private final Pattern headerPattern;
    private final List<SchemaValidator> schemaValidators;
    private final EnumSet<Validation> validations;
    private final RamlReport report;
    private final RamlViolations violations;

    public RamlValidatorChecker(Raml raml, List<SchemaValidator> schemaValidators) {
        this(raml, new Locator(), schemaValidators, EnumSet.allOf(Validation.class), null, null, null);
    }

    public RamlValidatorChecker(Raml raml, Locator locator, List<SchemaValidator> schemaValidators, EnumSet<Validation> validations, Pattern resourcePattern, Pattern parameterPattern, Pattern headerPattern) {
        this.raml = raml;
        this.locator = locator;
        this.resourcePattern = resourcePattern;
        this.parameterPattern = parameterPattern;
        this.headerPattern = headerPattern;
        this.schemaValidators = schemaValidators;
        this.validations = validations;
        this.report = new RamlReport(raml);
        this.violations = this.report.getValidationViolations();
    }

    public RamlValidatorChecker withChecks(Validation ... validations) {
        EnumSet<Validation> validationSet = validations.length == 0 ? EnumSet.noneOf(Validation.class) : EnumSet.copyOf(Arrays.asList(validations));
        return new RamlValidatorChecker(this.raml, this.locator, this.schemaValidators, validationSet, this.headerPattern, this.parameterPattern, this.resourcePattern);
    }

    public RamlValidatorChecker withResourcePattern(String regex) {
        return new RamlValidatorChecker(this.raml, this.locator, this.schemaValidators, this.validations, regex == null ? null : Pattern.compile(regex), this.parameterPattern, this.headerPattern);
    }

    public RamlValidatorChecker withParameterPattern(String regex) {
        return new RamlValidatorChecker(this.raml, this.locator, this.schemaValidators, this.validations, this.resourcePattern, regex == null ? null : Pattern.compile(regex), this.headerPattern);
    }

    public RamlValidatorChecker withHeaderPattern(String regex) {
        return new RamlValidatorChecker(this.raml, this.locator, this.schemaValidators, this.validations, this.resourcePattern, this.parameterPattern, regex == null ? null : Pattern.compile(regex));
    }

    public Locator getLocator() {
        return this.locator;
    }

    public RamlReport getReport() {
        return this.report;
    }

    private boolean has(Validation validation) {
        return this.validations.contains((Object)validation);
    }

    private void violation(String key, Object ... params) {
        this.violations.add(new Message(key, params));
    }

    public void description(Map<String, ?> params, ParamName paramName) {
        if (this.has(Validation.DESCRIPTION)) {
            for (Map.Entry<String, AbstractParam> param : CheckerHelper.paramEntries(params)) {
                this.description(param.getKey(), param.getValue(), paramName);
            }
        }
    }

    private void description(String name, AbstractParam param, ParamName paramName) {
        if (param.getDescription() == null || param.getDescription().isEmpty()) {
            this.violation("parameter.description.missing", new Object[]{this.locator, name, paramName});
        }
    }

    public void description(String desc) {
        if (this.has(Validation.DESCRIPTION) && (desc == null || desc.isEmpty())) {
            this.violation("description.missing", this.locator);
        }
    }

    public void description(List<DocumentationItem> docs) {
        if (this.has(Validation.DESCRIPTION) && (docs == null || docs.isEmpty())) {
            this.violation("description.missing", this.locator);
        }
    }

    public void empty(Resource resource) {
        if (this.has(Validation.EMPTY) && resource.getActions().isEmpty() && resource.getResources().isEmpty()) {
            this.violation("empty", this.locator);
        }
    }

    public void empty(Action action) {
        if (this.has(Validation.EMPTY) && action.getResponses().isEmpty()) {
            this.violation("empty", this.locator);
        }
    }

    private void baseUriParameters(Collection<String> names) {
        if (this.has(Validation.URI_PARAMETER)) {
            if (this.raml.getBaseUri() == null && !names.isEmpty()) {
                this.violation("baseUriParameters.illegal", this.locator);
            } else {
                for (String name : names) {
                    if ("version".equals(name)) {
                        this.violation("baseUriParameter.illegal", this.locator, name);
                        continue;
                    }
                    if (this.raml.getBaseUri().contains("{" + name + "}")) continue;
                    this.violation("baseUriParameter.invalid", this.locator, name);
                }
            }
        }
    }

    public void uriParameters(Collection<String> names, Resource resource) {
        if (this.has(Validation.URI_PARAMETER)) {
            for (String name : names) {
                if ("version".equals(name)) {
                    this.violation("uriParameter.illegal", this.locator, name);
                    continue;
                }
                if (resource.getUri().contains("{" + name + "}")) continue;
                this.violation("uriParameter.invalid", this.locator, name);
            }
        }
    }

    public void resourcePattern(Resource resource) {
        if (this.resourcePattern != null) {
            String uri = resource.getRelativeUri().replaceAll("\\{[^}/]+\\}", "");
            for (String part : uri.split("/")) {
                if (part == null || part.length() <= 0 || this.resourcePattern.matcher(part).matches()) continue;
                this.violation("resource.name.invalid", this.locator, this.resourcePattern.pattern());
            }
        }
    }

    public void parameters(Map<String, ?> params, ParamName paramName) {
        if (paramName == ParamName.BASE_URI) {
            this.baseUriParameters(params.keySet());
        }
        if (this.parameterPattern != null) {
            for (String name : params.keySet()) {
                if (this.parameterPattern.matcher(name).matches()) continue;
                this.violation("parameter.name.invalid", new Object[]{this.locator, name, paramName, this.parameterPattern.pattern()});
            }
        }
        if (this.has(Validation.PARAMETER)) {
            this.parameterDef(params, paramName);
        }
        if (this.has(Validation.EXAMPLE)) {
            ParameterChecker checker = new ParameterChecker(this.violations);
            for (Map.Entry<String, AbstractParam> param : CheckerHelper.paramEntries(params)) {
                this.parameterValues(param.getValue(), checker, new Message("parameter.condition", new Object[]{this.locator, param.getKey(), paramName}));
            }
        }
    }

    public void formParameters(MimeType mimeType) {
        if (this.has(Validation.PARAMETER) && !MediaType.valueOf(mimeType.getType()).isCompatibleWith(MediaType.FORM_URL_ENCODED) && !MediaType.valueOf(mimeType.getType()).isCompatibleWith(MediaType.MULTIPART)) {
            this.violation("formParameter.illegal", this.locator);
        }
    }

    private void parameterDef(Map<String, ?> params, ParamName paramName) {
        for (Map.Entry<String, AbstractParam> entry : CheckerHelper.paramEntries(params)) {
            ParamType type;
            String name = entry.getKey();
            AbstractParam param = entry.getValue();
            ParamType paramType = type = param.getType() == null ? ParamType.STRING : param.getType();
            if (type == ParamType.STRING) {
                this.minMaxNotAllowed(param, name, paramName);
                continue;
            }
            this.stringConstraintsNotAllowed(param, name, paramName);
            if (type != ParamType.INTEGER && type != ParamType.NUMBER) {
                this.minMaxNotAllowed(param, name, paramName);
            }
            if (type != ParamType.FILE) continue;
            this.violations.addIf(paramName != ParamName.FORM, new Message("parameter.file.illegal", new Object[]{this.locator, name, paramName}));
        }
    }

    private void stringConstraintsNotAllowed(AbstractParam param, String name, ParamName paramName) {
        this.violations.addIf(param.getEnumeration() != null, new Message(PARAM_CONDITION_ILLEGAL, new Object[]{this.locator, name, paramName, "enum"}));
        this.violations.addIf(param.getPattern() != null, new Message(PARAM_CONDITION_ILLEGAL, new Object[]{this.locator, name, paramName, "pattern"}));
        this.violations.addIf(param.getMinLength() != null, new Message(PARAM_CONDITION_ILLEGAL, new Object[]{this.locator, name, paramName, "minLength"}));
        this.violations.addIf(param.getMaxLength() != null, new Message(PARAM_CONDITION_ILLEGAL, new Object[]{this.locator, name, paramName, "maxLength"}));
    }

    private void minMaxNotAllowed(AbstractParam param, String name, ParamName paramName) {
        this.violations.addIf(param.getMinimum() != null, new Message(PARAM_CONDITION_ILLEGAL, new Object[]{this.locator, name, paramName, "minimum"}));
        this.violations.addIf(param.getMaximum() != null, new Message(PARAM_CONDITION_ILLEGAL, new Object[]{this.locator, name, paramName, "maximum"}));
    }

    private void parameterValues(AbstractParam param, ParameterChecker checker, Message message) {
        if (param.getExample() != null) {
            checker.checkParameter(param, param.getExample(), message.withParam("example"));
        }
        if (param.getDefaultValue() != null) {
            checker.checkParameter(param, param.getDefaultValue(), message.withParam("default value"));
        }
    }

    public void headerPattern(Collection<String> names) {
        if (this.headerPattern != null) {
            for (String name : names) {
                if (this.headerPattern.matcher(name).matches()) continue;
                this.violation("header.name.invalid", this.locator, name, this.headerPattern.pattern());
            }
        }
    }

    public void exampleSchema(MimeType mimeType) {
        if (this.has(Validation.EXAMPLE)) {
            String schema = mimeType.getSchema();
            String example = mimeType.getExample();
            SchemaValidator validator = CheckerHelper.findSchemaValidator(this.schemaValidators, MediaType.valueOf(mimeType.getType()));
            if (schema != null && example != null && validator != null) {
                validator.validate(new NamedReader(example, new Message("example", new Object[0]).toString()), CheckerHelper.resolveSchema(this.raml, schema), this.violations, new Message("schema.example.mismatch", this.locator, example));
            }
        }
    }

    static enum ParamName {
        BASE_URI("baseUriParameter"),
        URI("uriParameter"),
        QUERY("queryParameter"),
        HEADER("header"),
        FORM("formParameter");

        private final String value;

        private ParamName(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

