/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.jaxrs;

import guru.nidi.ramltester.core.DummyReportAggragator;
import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportAggregator;
import guru.nidi.ramltester.jaxrs.CheckingClientFilter;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.RamlResponse;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

public class CheckingWebTarget
implements WebTarget {
    private final RamlChecker checker;
    private final WebTarget target;
    private RamlReport report;
    private ReportAggregator aggregator = new DummyReportAggragator();

    public CheckingWebTarget(RamlChecker checker, WebTarget target) {
        this.checker = checker;
        this.target = target;
        if (target.getConfiguration().getProperty("checked") != null) {
            throw new IllegalStateException("This WebTarget is already checking");
        }
        target.property("checked", (Object)true);
        target.register((Object)new CheckingClientFilter(this));
    }

    void check(RamlRequest request, RamlResponse response) {
        this.report = this.checker.check(request, response);
        this.aggregator.addReport(this.report);
    }

    public RamlReport getLastReport() {
        return this.report;
    }

    public CheckingWebTarget aggregating(ReportAggregator aggregator) {
        this.aggregator = aggregator;
        return this;
    }

    public URI getUri() {
        return this.target.getUri();
    }

    public UriBuilder getUriBuilder() {
        return this.target.getUriBuilder();
    }

    public WebTarget path(String path) {
        return this.target.path(path);
    }

    public WebTarget resolveTemplate(String name, Object value) {
        return this.target.resolveTemplate(name, value);
    }

    public WebTarget resolveTemplate(String name, Object value, boolean encodeSlashInPath) {
        return this.target.resolveTemplate(name, value, encodeSlashInPath);
    }

    public WebTarget resolveTemplateFromEncoded(String name, Object value) {
        return this.target.resolveTemplateFromEncoded(name, value);
    }

    public WebTarget resolveTemplates(Map<String, Object> templateValues) {
        return this.target.resolveTemplates(templateValues);
    }

    public WebTarget resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) {
        return this.target.resolveTemplates(templateValues, encodeSlashInPath);
    }

    public WebTarget resolveTemplatesFromEncoded(Map<String, Object> templateValues) {
        return this.target.resolveTemplatesFromEncoded(templateValues);
    }

    public WebTarget matrixParam(String name, Object ... values) {
        return this.target.matrixParam(name, values);
    }

    public WebTarget queryParam(String name, Object ... values) {
        return this.target.queryParam(name, values);
    }

    public Invocation.Builder request() {
        return this.target.request();
    }

    public Invocation.Builder request(String ... acceptedResponseTypes) {
        return this.target.request(acceptedResponseTypes);
    }

    public Invocation.Builder request(MediaType ... acceptedResponseTypes) {
        return this.target.request(acceptedResponseTypes);
    }

    public Configuration getConfiguration() {
        return this.target.getConfiguration();
    }

    public WebTarget property(String name, Object value) {
        return (WebTarget)this.target.property(name, value);
    }

    public WebTarget register(Class<?> componentClass) {
        return (WebTarget)this.target.register(componentClass);
    }

    public WebTarget register(Class<?> componentClass, int priority) {
        return (WebTarget)this.target.register(componentClass, priority);
    }

    public WebTarget register(Class<?> componentClass, Class<?> ... contracts) {
        return (WebTarget)this.target.register(componentClass, (Class[])contracts);
    }

    public WebTarget register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        return (WebTarget)this.target.register(componentClass, contracts);
    }

    public WebTarget register(Object component) {
        return (WebTarget)this.target.register(component);
    }

    public WebTarget register(Object component, int priority) {
        return (WebTarget)this.target.register(component, priority);
    }

    public WebTarget register(Object component, Class<?> ... contracts) {
        return (WebTarget)this.target.register(component, (Class[])contracts);
    }

    public WebTarget register(Object component, Map<Class<?>, Integer> contracts) {
        return (WebTarget)this.target.register(component, contracts);
    }
}

