/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.jaxrs;

import guru.nidi.ramltester.jaxrs.JaxrsContextRamlMessage;
import guru.nidi.ramltester.jaxrs.SavingOutputStream;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.FormDecoder;
import guru.nidi.ramltester.util.UriComponents;
import javax.ws.rs.client.ClientRequestContext;

public class JaxrsContextRamlRequest
extends JaxrsContextRamlMessage
implements RamlRequest {
    private final ClientRequestContext context;
    private final UriComponents uriComponents;

    public JaxrsContextRamlRequest(ClientRequestContext context) {
        this.context = context;
        this.uriComponents = UriComponents.fromHttpUrl(context.getUri().toString());
    }

    @Override
    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        return (baseUri == null ? this.uriComponents.getServer() : baseUri) + this.uriComponents.getPath();
    }

    @Override
    public String getMethod() {
        return this.context.getMethod();
    }

    @Override
    public Values getQueryValues() {
        return this.uriComponents.getQueryParameters();
    }

    @Override
    public Values getFormValues() {
        return new FormDecoder().decode(this);
    }

    @Override
    public Values getHeaderValues() {
        return this.headersOf(this.context.getHeaders());
    }

    @Override
    public String getContentType() {
        return this.context.getMediaType() == null ? null : this.context.getMediaType().toString();
    }

    @Override
    public byte[] getContent() {
        if (this.context.getEntityStream() instanceof SavingOutputStream) {
            return ((SavingOutputStream)this.context.getEntityStream()).getSaved();
        }
        throw new IllegalStateException("Request data was not saved");
    }
}

