/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.restassured;

import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.FilterableResponseSpecification;
import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportStore;
import guru.nidi.ramltester.core.ThreadLocalReportStore;
import guru.nidi.ramltester.restassured.RestAssuredRamlRequest;
import guru.nidi.ramltester.restassured.RestAssuredRamlResponse;

public class RamlValidationFilter
implements Filter {
    private final RamlChecker ramlChecker;
    private final ReportStore reportStore;

    public RamlValidationFilter(RamlChecker ramlChecker) {
        this.ramlChecker = ramlChecker;
        this.reportStore = new ThreadLocalReportStore();
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext filterContext) {
        Response response = filterContext.next(requestSpec, responseSpec);
        RamlReport report = this.ramlChecker.check(new RestAssuredRamlRequest(requestSpec, filterContext), new RestAssuredRamlResponse(response));
        this.reportStore.storeReport(report);
        return response;
    }

    public ReportStore getReportStore() {
        return this.reportStore;
    }
}

