/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.restassured;

import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.restassured.RestAssuredRamlMessage;

class RestAssuredRamlRequest
extends RestAssuredRamlMessage
implements RamlRequest {
    private final FilterableRequestSpecification requestSpec;
    private final FilterContext filterContext;

    RestAssuredRamlRequest(FilterableRequestSpecification requestSpec, FilterContext filterContext) {
        this.requestSpec = requestSpec;
        this.filterContext = filterContext;
    }

    @Override
    public Values getHeaderValues() {
        return this.headersToValues(this.requestSpec.getHeaders());
    }

    @Override
    public String getContentType() {
        return this.requestSpec.getRequestContentType();
    }

    @Override
    public byte[] getContent() {
        String body = (String)this.requestSpec.getBody();
        return body == null ? null : body.getBytes();
    }

    @Override
    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        return baseUri == null || baseUri.length() == 0 ? this.filterContext.getRequestURI() : this.filterContext.getRequestURI().replace(this.requestSpec.getBaseUri(), baseUri);
    }

    @Override
    public String getMethod() {
        return this.filterContext.getRequestMethod().toString();
    }

    @Override
    public Values getQueryValues() {
        return this.mapToValues(this.requestSpec.getQueryParams());
    }

    @Override
    public Values getFormValues() {
        return this.mapToValues(this.requestSpec.getFormParams());
    }
}

