/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.validator;

import guru.nidi.loader.Loader;
import guru.nidi.loader.use.xml.LoaderLSResourceResolver;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JavaXmlSchemaValidator
implements SchemaValidator {
    private static final MediaType APPLICATION_XML = MediaType.valueOf("application/xml");
    private static final MediaType TEXT_XML = MediaType.valueOf("text/xml");
    private final Loader loader;

    private JavaXmlSchemaValidator(Loader loader) {
        this.loader = loader;
    }

    public JavaXmlSchemaValidator() {
        this(null);
    }

    @Override
    public SchemaValidator withLoader(Loader loader) {
        return new JavaXmlSchemaValidator(loader);
    }

    @Override
    public boolean supports(MediaType mediaType) {
        return mediaType.isCompatibleWith(TEXT_XML) || mediaType.isCompatibleWith(APPLICATION_XML);
    }

    @Override
    public void validate(Reader content, Reader schema, RamlViolations violations, Message message) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schemaFactory.setResourceResolver((LSResourceResolver)new LoaderLSResourceResolver(this.loader));
            Schema s = schemaFactory.newSchema(new StreamSource(schema));
            Validator validator = s.newValidator();
            validator.setErrorHandler(new ViolationsWritingErrorHandler(violations, message));
            validator.validate(new StreamSource(content));
        }
        catch (IOException | SAXException e) {
            violations.add(message.withParam(e.getMessage()));
        }
    }

    private static class ViolationsWritingErrorHandler
    implements ErrorHandler {
        private final RamlViolations violations;
        private final Message message;

        public ViolationsWritingErrorHandler(RamlViolations violations, Message message) {
            this.violations = violations;
            this.message = message;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.violations.add(this.message.withMessageParam("javaXmlSchemaValidator.schema.warn", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.violations.add(this.message.withMessageParam("javaXmlSchemaValidator.schema.error", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.violations.add(this.message.withMessageParam("javaXmlSchemaValidator.schema.fatal", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
        }
    }
}

