/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester;

import guru.nidi.loader.Loader;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.validator.JavaXmlSchemaValidator;
import guru.nidi.ramltester.validator.JsonSchemaValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SchemaValidators {
    private final List<SchemaValidator> validators;

    private SchemaValidators(List<SchemaValidator> validators) {
        this.validators = validators;
    }

    public static SchemaValidators empty() {
        return new SchemaValidators(Collections.emptyList());
    }

    public static SchemaValidators standard() {
        return new SchemaValidators(Arrays.asList(new JsonSchemaValidator(), new JavaXmlSchemaValidator()));
    }

    public SchemaValidators addSchemaValidator(SchemaValidator schemaValidator) {
        ArrayList<SchemaValidator> newValidators = new ArrayList<SchemaValidator>(this.validators);
        newValidators.add(schemaValidator);
        return new SchemaValidators(newValidators);
    }

    public SchemaValidators withloader(Loader loader) {
        ArrayList<SchemaValidator> newValidators = new ArrayList<SchemaValidator>();
        for (SchemaValidator validator : this.validators) {
            newValidators.add(validator.withLoader(loader));
        }
        return new SchemaValidators(newValidators);
    }

    public List<SchemaValidator> getValidators() {
        return this.validators;
    }
}

