/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.Usage;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.raml.model.Raml;

public class RamlReport {
    private final Raml raml;
    private final Usage usage = new Usage();
    private final RamlViolations requestViolations = new RamlViolations();
    private final RamlViolations responseViolations = new RamlViolations();
    private final RamlViolations validationViolations = new RamlViolations();

    public RamlReport(Raml raml) {
        this.raml = raml;
    }

    public static RamlReport fromException(Raml raml, Exception cause) {
        RamlReport report = new RamlReport(raml);
        StringWriter out = new StringWriter();
        cause.printStackTrace(new PrintWriter(out));
        report.getRequestViolations().add("checking.exception", out.toString());
        return report;
    }

    public boolean isEmpty() {
        return this.requestViolations.isEmpty() && this.responseViolations.isEmpty() && this.validationViolations.isEmpty();
    }

    public String toString() {
        return "RamlReport{requestViolations=" + this.requestViolations + ", responseViolations=" + this.responseViolations + ", validationViolations=" + this.validationViolations + '}';
    }

    Usage getUsage() {
        return this.usage;
    }

    public Raml getRaml() {
        return this.raml;
    }

    public RamlViolations getRequestViolations() {
        return this.requestViolations;
    }

    public RamlViolations getResponseViolations() {
        return this.responseViolations;
    }

    public RamlViolations getValidationViolations() {
        return this.validationViolations;
    }
}

