/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.RamlViolations;
import java.util.Arrays;
import java.util.List;
import org.raml.model.SecurityScheme;
import org.raml.model.SecuritySettings;

enum SecuritySchemeType {
    OAUTH_10("OAuth 1.0"){

        @Override
        public void check(SecurityScheme scheme, RamlViolations violations) {
            SecuritySettings settings = scheme.getSettings();
            violations.addIf(settings == null || settings.getRequestTokenUri() == null, "oauth10.requestTokenUri.missing", new Object[0]);
            violations.addIf(settings == null || settings.getAuthorizationUri() == null, "oauth10.authorizationUri.missing", new Object[0]);
            violations.addIf(settings == null || settings.getTokenCredentialsUri() == null, "oauth10.tokenCredentialsUri.missing", new Object[0]);
        }
    }
    ,
    OAUTH_20("OAuth 2.0"){
        private final List<String> GRANTS = Arrays.asList("code", "token", "owner", "credentials");

        @Override
        public void check(SecurityScheme scheme, RamlViolations violations) {
            SecuritySettings settings = scheme.getSettings();
            violations.addIf(settings == null || settings.getAuthorizationUri() == null, "oauth20.authorizationUri.missing", new Object[0]);
            violations.addIf(settings == null || settings.getAccessTokenUri() == null, "oauth20.accessTokenUri.missing", new Object[0]);
            violations.addIf(settings == null || settings.getAuthorizationGrants().isEmpty(), "oauth20.authorizationGrants.missing", new Object[0]);
            if (settings != null) {
                for (String grant : settings.getAuthorizationGrants()) {
                    violations.addIf(!this.GRANTS.contains(grant), "oauth20.authorizationGrant.invalid", grant);
                }
            }
        }
    }
    ,
    BASIC("Basic Authentication"){

        @Override
        public void check(SecurityScheme scheme, RamlViolations violations) {
        }
    }
    ,
    DIGEST("Digest Authentication"){

        @Override
        public void check(SecurityScheme scheme, RamlViolations violations) {
        }
    };

    private final String name;

    private SecuritySchemeType(String name) {
        this.name = name;
    }

    public abstract void check(SecurityScheme var1, RamlViolations var2);

    public static SecuritySchemeType byName(String name) {
        for (SecuritySchemeType type : SecuritySchemeType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }
}

