/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Values
implements Iterable<Map.Entry<String, List<Object>>> {
    private final Map<String, List<Object>> values = new HashMap<String, List<Object>>();

    public Values() {
    }

    public Values(Map<String, String[]> values) {
        for (Map.Entry<String, String[]> entry : values.entrySet()) {
            this.addValues(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
    }

    public int size() {
        return this.values.size();
    }

    public List<Object> get(String name) {
        return this.values.get(name);
    }

    public Values addValue(String name, Object value) {
        List<Object> vs = this.values.get(name);
        if (vs == null) {
            vs = new ArrayList<Object>();
            this.values.put(name, vs);
        }
        vs.add(value);
        return this;
    }

    public void setValue(String name, String value) {
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(value);
        this.values.put(name, vs);
    }

    public void addValues(String name, Iterable<?> values) {
        for (Object value : values) {
            this.addValue(name, value);
        }
    }

    public void addValues(Values values) {
        for (Map.Entry<String, List<Object>> value : values) {
            this.addValues(value.getKey(), (Iterable)value.getValue());
        }
    }

    @Override
    public Iterator<Map.Entry<String, List<Object>>> iterator() {
        return this.values.entrySet().iterator();
    }

    public Set<String> names() {
        return this.values.keySet();
    }

    public Map<String, List<Object>> asMap() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Values values1 = (Values)o;
        return this.values.equals(values1.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "Values{" + this.values + '}';
    }
}

