/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.spring;

import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportStore;
import guru.nidi.ramltester.spring.SpringClientHttpRamlResponse;
import guru.nidi.ramltester.spring.SpringHttpRamlRequest;
import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpResponse;

public class RamlRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final RamlChecker checker;
    private final boolean notSending;
    private final ReportStore reportStore;

    public RamlRequestInterceptor(RamlChecker checker, boolean notSending, ReportStore reportStore) {
        this.checker = checker;
        this.notSending = notSending;
        this.reportStore = reportStore;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        RamlReport report;
        ClientHttpResponse response;
        this.reportStore.storeReport(null);
        SpringHttpRamlRequest ramlRequest = new SpringHttpRamlRequest(request, body);
        if (this.notSending) {
            response = new MockClientHttpResponse((byte[])null, HttpStatus.NO_CONTENT);
            report = this.checker.check(ramlRequest);
        } else {
            response = execution.execute(request, body);
            SpringClientHttpRamlResponse ramlResponse = new SpringClientHttpRamlResponse(response);
            report = this.checker.check(ramlRequest, ramlResponse);
        }
        this.reportStore.storeReport(report);
        return response;
    }
}

