/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.util;

import guru.nidi.ramltester.model.Values;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UriComponents {
    private final String scheme;
    private final String userInfo;
    private final String host;
    private final Integer port;
    private final String path;
    private final String queryString;
    private final Values queryParameters;

    private UriComponents(String scheme, String userInfo, String host, Integer port, String path, String query) {
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.queryString = query;
        this.queryParameters = UriComponents.parseQuery(query);
    }

    public static UriComponents fromHttpUrl(String httpUrl) {
        Matcher m = HttpUrl.PATTERN.matcher(httpUrl);
        if (m.matches()) {
            String scheme = m.group(1) == null ? null : m.group(1).toLowerCase(Locale.ENGLISH);
            String host = m.group(5);
            if (scheme != null && scheme.length() > 0 && (host == null || host.length() == 0)) {
                throw new IllegalArgumentException("[" + httpUrl + "] is not a valid HTTP URL");
            }
            String portString = m.group(7);
            Integer port = portString != null && portString.length() > 0 ? Integer.valueOf(Integer.parseInt(portString)) : null;
            String path = m.group(8);
            String query = m.group(10);
            String userInfo = m.group(4);
            return new UriComponents(scheme, userInfo, host, port, path, query);
        }
        throw new IllegalArgumentException("[" + httpUrl + "] is not a valid HTTP URL");
    }

    public static Values parseQuery(String query) {
        Values q = new Values();
        if (query != null) {
            Matcher m = QueryParam.PATTERN.matcher(query);
            while (m.find()) {
                String name = m.group(1);
                String eq = m.group(2);
                String value = m.group(3);
                String emptyValue = eq != null && eq.length() > 0 ? "" : null;
                q.addValue(name, value == null ? emptyValue : value);
            }
        }
        return q;
    }

    public String getServer() {
        return (this.scheme == null ? "" : this.scheme + "://") + (this.userInfo == null ? "" : this.userInfo + "@") + (this.host == null ? "" : this.host) + (this.port == null ? "" : ":" + this.port);
    }

    public String getUri() {
        return this.getServer() + (this.path == null ? "" : this.path);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Values getQueryParameters() {
        return this.queryParameters;
    }

    private static final class QueryParam {
        public static final Pattern PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
        public static final int GROUP_NAME = 1;
        public static final int GROUP_EQUAL = 2;
        public static final int GROUP_VALUE = 3;

        private QueryParam() {
        }
    }

    private static final class HttpUrl {
        private static final String HTTP = "(?i)(http|https):";
        private static final String USERINFO = "([^@/]*)";
        private static final String HOST_IPV4 = "[^\\[/?#:]*";
        private static final String HOST_IPV6 = "\\[[\\p{XDigit}:\\.]*[%\\p{Alnum}]*\\]";
        private static final String HOST = "(\\[[\\p{XDigit}:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)";
        private static final String PORT = "(\\d*)";
        private static final String PATH = "([^?#]*)";
        private static final String LAST = "(.*)";
        public static final Pattern PATTERN = Pattern.compile("^(?i)(http|https):(//(([^@/]*)@)?(\\[[\\p{XDigit}:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)(:(\\d*))?)?([^?#]*)(\\?(.*))?");
        public static final int GROUP_SCHEME = 1;
        public static final int GROUP_USER = 4;
        public static final int GROUP_HOST = 5;
        public static final int GROUP_PORT = 7;
        public static final int GROUP_PATH = 8;
        public static final int GROUP_QUERY = 10;

        private HttpUrl() {
        }
    }
}

