/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester;

import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportAggregator;
import guru.nidi.ramltester.core.Usage;
import guru.nidi.ramltester.core.UsageBuilder;
import guru.nidi.ramltester.core.UsageProvider;
import guru.nidi.ramltester.model.internal.RamlApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SimpleReportAggregator
implements ReportAggregator,
UsageProvider {
    private RamlApi raml;
    private final List<RamlReport> reports = new ArrayList<RamlReport>();

    @Override
    public RamlReport addReport(RamlReport report) {
        if (report != null) {
            if (this.raml == null) {
                this.raml = report.getRaml();
            } else if (!this.raml.title().equals(report.getRaml().title())) {
                throw new IllegalArgumentException("This aggregator can only be used with one RamlDefinition. To work with multiple RamlDefinitions, use MultiReportAggregator.");
            }
            this.reports.add(report);
        }
        return report;
    }

    @Override
    public Iterable<Map.Entry<String, Usage>> usages() {
        return this.reports.isEmpty() ? Collections.emptyMap().entrySet() : Collections.singletonMap(this.raml.title(), UsageBuilder.usage(this.raml, this.reports)).entrySet();
    }

    @Override
    public void clear() {
        this.reports.clear();
    }

    public List<RamlReport> getReports() {
        return this.reports;
    }

    protected RamlApi getRaml() {
        return this.raml;
    }

    @Override
    public Usage getUsage() {
        return UsageBuilder.usage(this.raml, this.getReports());
    }
}

