/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.model.internal.Api08;
import guru.nidi.ramltester.model.internal.Api10;
import guru.nidi.ramltester.model.internal.RamlApi;
import java.util.List;
import org.raml.v2.api.RamlModelResult;

public class CheckerConfig {
    public final RamlModelResult raml;
    public final List<SchemaValidator> schemaValidators;
    public final String baseUri;
    public final boolean includeServletPath;
    public final boolean ignoreXheaders;
    public final boolean failFast;

    public CheckerConfig(RamlModelResult raml, List<SchemaValidator> schemaValidators) {
        this(raml, schemaValidators, null, false, false, false);
    }

    public CheckerConfig(RamlModelResult raml, List<SchemaValidator> schemaValidators, String baseUri, boolean includeServletPath, boolean ignoreXheaders, boolean failFast) {
        this.raml = raml;
        this.schemaValidators = schemaValidators;
        this.baseUri = baseUri;
        this.includeServletPath = includeServletPath;
        this.ignoreXheaders = ignoreXheaders;
        this.failFast = failFast;
    }

    public RamlApi getRaml() {
        return this.raml.isVersion08() ? new Api08(this.raml.getApiV08()) : new Api10(this.raml.getApiV10());
    }

    public CheckerConfig assumingBaseUri(String baseUri) {
        return new CheckerConfig(this.raml, this.schemaValidators, baseUri, this.includeServletPath, this.ignoreXheaders, this.failFast);
    }

    public CheckerConfig assumingBaseUri(String baseUri, boolean includeServletPath) {
        return new CheckerConfig(this.raml, this.schemaValidators, baseUri, includeServletPath, this.ignoreXheaders, this.failFast);
    }

    public CheckerConfig ignoringXheaders() {
        return this.ignoringXheaders(true);
    }

    public CheckerConfig ignoringXheaders(boolean ignoreXheaders) {
        return new CheckerConfig(this.raml, this.schemaValidators, this.baseUri, this.includeServletPath, ignoreXheaders, this.failFast);
    }

    public CheckerConfig includeServletPath() {
        return this.includeServletPath(true);
    }

    public CheckerConfig includeServletPath(boolean includeServletPath) {
        return new CheckerConfig(this.raml, this.schemaValidators, this.baseUri, includeServletPath, this.ignoreXheaders, this.failFast);
    }

    public CheckerConfig failFast() {
        return this.failFast(true);
    }

    public CheckerConfig failFast(boolean failFast) {
        return new CheckerConfig(this.raml, this.schemaValidators, this.baseUri, this.includeServletPath, this.ignoreXheaders, failFast);
    }
}

