/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.NamedReader;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.model.RamlMessage;
import guru.nidi.ramltester.model.internal.RamlApiResponse;
import guru.nidi.ramltester.model.internal.RamlBody;
import guru.nidi.ramltester.model.internal.RamlMethod;
import guru.nidi.ramltester.model.internal.RamlResource;
import guru.nidi.ramltester.model.internal.RamlType;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

final class CheckerHelper {
    private CheckerHelper() {
    }

    public static boolean isNoOrEmptyBodies(List<RamlBody> bodies) {
        return bodies == null || bodies.isEmpty();
    }

    public static boolean hasContent(RamlMessage message) {
        return message.getContent() != null && message.getContent().length > 0;
    }

    public static boolean existSchemalessBody(List<RamlBody> bodies) {
        for (RamlBody mimeType : bodies) {
            if (mimeType.type() != null) continue;
            return true;
        }
        return false;
    }

    public static RamlType findUriParam(String uriParam, RamlResource resource) {
        RamlType param = CheckerHelper.typeByName(resource.uriParameters(), uriParam);
        if (param != null) {
            return param;
        }
        if (resource.parentResource() != null) {
            return CheckerHelper.findUriParam(uriParam, resource.parentResource());
        }
        return null;
    }

    public static SchemaValidator findSchemaValidator(List<SchemaValidator> validators, MediaType mediaType) {
        for (SchemaValidator validator : validators) {
            if (!validator.supports(mediaType)) continue;
            return validator;
        }
        return null;
    }

    public static List<RamlType> getEffectiveBaseUriParams(List<RamlType> baseUriParams, RamlMethod action) {
        ArrayList<RamlType> params = new ArrayList<RamlType>();
        if (action.baseUriParameters() != null) {
            params.addAll(action.baseUriParameters());
        }
        CheckerHelper.addNotSetBaseUriParams(action.resource(), params);
        if (baseUriParams != null) {
            for (RamlType parameter : baseUriParams) {
                if (CheckerHelper.typeNamesOf(params).contains(parameter.name())) continue;
                params.add(parameter);
            }
        }
        return params;
    }

    private static void addNotSetBaseUriParams(RamlResource resource, List<RamlType> params) {
        for (RamlType parameter : resource.baseUriParameters()) {
            if (CheckerHelper.typeNamesOf(params).contains(parameter.name())) continue;
            params.add(parameter);
        }
        if (resource.parentResource() != null) {
            CheckerHelper.addNotSetBaseUriParams(resource.parentResource(), params);
        }
    }

    public static Reader resolveSchema(String type, String typeDef) {
        if (typeDef == null) {
            return new NamedReader(type, new Message("schema.inline", new Object[0]).toString());
        }
        return type.equals(typeDef) ? new NamedReader(typeDef, new Message("schema.inline", new Object[0]).toString()) : new NamedReader(typeDef, new Message("schema", type).toString());
    }

    public static <T> List<T> mergeLists(List<T> list1, List<T> list2) {
        ArrayList<T> res = new ArrayList<T>();
        res.addAll(list1);
        res.addAll(list2);
        return res;
    }

    public static RamlApiResponse responseByCode(List<RamlApiResponse> responses, String code) {
        for (RamlApiResponse response : responses) {
            if (!response.code().equals(code)) continue;
            return response;
        }
        return null;
    }

    public static RamlType typeByName(List<RamlType> types, String name) {
        List<RamlType> res = CheckerHelper.typesByName(types, name);
        if (res.size() > 1) {
            throw new IllegalArgumentException("Expected only one parameter with given name " + name);
        }
        return res.isEmpty() ? null : res.get(0);
    }

    public static List<RamlType> typesByName(List<RamlType> types, String name) {
        ArrayList<RamlType> res = new ArrayList<RamlType>();
        for (RamlType type : types) {
            if (!type.name().equals(name)) continue;
            res.add(type);
        }
        return res;
    }

    public static List<String> typeNamesOf(List<RamlType> types) {
        ArrayList<String> res = new ArrayList<String>();
        for (RamlType type : types) {
            res.add(type.name());
        }
        return res;
    }

    public static List<String> codesOf(List<RamlApiResponse> responses) {
        ArrayList<String> res = new ArrayList<String>();
        for (RamlApiResponse response : responses) {
            res.add(response.code());
        }
        return res;
    }
}

