/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.MediaTypeMatch;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.RamlResponse;
import guru.nidi.ramltester.model.internal.RamlMethod;
import guru.nidi.ramltester.util.InvalidMediaTypeException;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ContentNegotiationChecker {
    private final RamlViolations requestViolations;
    private final RamlViolations responseViolations;

    public ContentNegotiationChecker(RamlViolations requestViolations, RamlViolations responseViolations) {
        this.requestViolations = requestViolations;
        this.responseViolations = responseViolations;
    }

    public void check(RamlRequest request, RamlResponse response, RamlMethod action, MediaTypeMatch typeMatch) {
        String accept = this.acceptHeader(request, response, typeMatch);
        if (accept == null) {
            return;
        }
        MediaType bestMatch = null;
        for (MediaType acceptType : this.acceptMediaTypes(accept)) {
            for (MediaType modelType : typeMatch.getDefinedTypes()) {
                if (!acceptType.isCompatibleWith(modelType)) continue;
                if (bestMatch == null) {
                    bestMatch = acceptType;
                }
                if (!typeMatch.getMatchingMedia().equals(modelType)) continue;
                if (acceptType.getQualityParameter() < bestMatch.getQualityParameter()) {
                    Locator locator = new Locator(action);
                    locator.responseCode(Integer.toString(response.getStatus()));
                    this.responseViolations.add(new Message("mediaType.better", locator, accept, bestMatch, response.getContentType()));
                }
                return;
            }
        }
        this.responseViolations.add(new Message("contentType.mismatch", accept, response.getContentType()));
    }

    private String acceptHeader(RamlRequest request, RamlResponse response, MediaTypeMatch typeMatch) {
        if (typeMatch == null || response.getContentType() == null || response.getContentType().isEmpty()) {
            return null;
        }
        List<Object> header = request.getHeaderValues().get("Accept");
        if (header == null || header.isEmpty()) {
            return null;
        }
        String accept = header.get(0).toString().trim();
        if (accept.length() == 0) {
            return null;
        }
        return accept;
    }

    private List<MediaType> acceptMediaTypes(String accept) {
        ArrayList<MediaType> acceptTypes = new ArrayList<MediaType>();
        for (String type : accept.split(",")) {
            try {
                MediaType acceptType = MediaType.valueOf(type);
                acceptTypes.add(acceptType);
            }
            catch (InvalidMediaTypeException e) {
                this.requestViolations.add(new Message("mediaType.illegal", new Message("accept.header", new Object[0]), type, e.getMessage()));
            }
        }
        Collections.sort(acceptTypes, MediaType.QUALITY_COMPARATOR);
        return acceptTypes;
    }
}

