/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.model.internal.RamlBody;
import guru.nidi.ramltester.model.internal.RamlMethod;
import guru.nidi.ramltester.model.internal.RamlResource;
import guru.nidi.ramltester.util.Message;

final class Locator {
    private RamlResource resource;
    private RamlMethod action;
    private RamlBody requestMime;
    private String responseCode;
    private RamlBody responseMime;

    public Locator() {
    }

    public Locator(RamlResource resource) {
        this.resource(resource);
    }

    public Locator(RamlMethod action) {
        this.action(action);
    }

    public Locator(RamlBody mimeType) {
        this.requestMime(mimeType);
    }

    public void resource(RamlResource resource) {
        this.resource = resource;
        this.action = null;
        this.requestMime = null;
        this.responseCode = null;
        this.responseMime = null;
    }

    public void action(RamlMethod action) {
        this.resource = action.resource();
        this.action = action;
        this.requestMime = null;
        this.responseCode = null;
        this.responseMime = null;
    }

    public void requestMime(RamlBody requestMime) {
        this.requestMime = requestMime;
        this.responseCode = null;
        this.responseMime = null;
    }

    public void responseCode(String responseCode) {
        this.responseCode = responseCode;
        this.requestMime = null;
        this.responseMime = null;
    }

    public void responseMime(RamlBody responseMime) {
        this.responseMime = responseMime;
        this.requestMime = null;
    }

    public String toString() {
        if (this.responseCode != null) {
            return this.actionString() + " " + new Message("response", this.responseCode).toString() + (this.responseMime == null ? "" : " " + new Message("mimeType", this.responseMime.name()).toString());
        }
        if (this.requestMime != null) {
            return (this.action == null ? "" : this.actionString() + " ") + new Message("mimeType", this.requestMime.name()).toString();
        }
        if (this.action != null) {
            return this.actionString();
        }
        if (this.resource != null) {
            return new Message("resource", this.resource.resourcePath()).toString();
        }
        return new Message("root", new Object[0]).toString();
    }

    private String actionString() {
        return new Message("action", this.action.method(), this.action.resource().resourcePath()).toString();
    }
}

