/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CheckerHelper;
import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.model.RamlMessage;
import guru.nidi.ramltester.model.internal.RamlBody;
import guru.nidi.ramltester.util.InvalidMediaTypeException;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class MediaTypeMatch {
    private final MediaType targetType;
    private final Collection<MediaType> definedTypes;
    private final MediaType matchingMedia;
    private final RamlBody matchingMime;

    private MediaTypeMatch(MediaType targetType, Collection<MediaType> definedTypes, MediaType matchingMedia, RamlBody matchingMime) {
        this.targetType = targetType;
        this.definedTypes = definedTypes;
        this.matchingMedia = matchingMedia;
        this.matchingMime = matchingMime;
    }

    public MediaType getTargetType() {
        return this.targetType;
    }

    public Collection<MediaType> getDefinedTypes() {
        return this.definedTypes;
    }

    public MediaType getMatchingMedia() {
        return this.matchingMedia;
    }

    public RamlBody getMatchingMime() {
        return this.matchingMime;
    }

    public String getTargetCharset() {
        return this.targetType.getCharset("iso-8859-1");
    }

    public static MediaTypeMatch find(RamlViolations violations, RamlMessage message, List<RamlBody> bodies, Locator locator) {
        MediaType targetType;
        if (CheckerHelper.isNoOrEmptyBodies(bodies)) {
            violations.addIf(CheckerHelper.hasContent(message), "body.superfluous", locator);
            return null;
        }
        if (message.getContentType() == null) {
            violations.addIf(CheckerHelper.hasContent(message) || !CheckerHelper.existSchemalessBody(bodies), "contentType.missing", new Object[0]);
            return null;
        }
        try {
            targetType = MediaType.valueOf(message.getContentType());
        }
        catch (InvalidMediaTypeException e) {
            violations.add("mediaType.illegal", locator, message.getContentType(), e.getMessage());
            return null;
        }
        Map<MediaType, RamlBody> mediaTypes = MediaTypeMatch.mediaTypes(violations, bodies, locator);
        List<Map.Entry<MediaType, RamlBody>> bestMatches = MediaTypeMatch.findBestMatches(mediaTypes, targetType);
        if (bestMatches.isEmpty()) {
            violations.add("mediaType.undefined", locator, message.getContentType());
            return null;
        }
        if (bestMatches.size() > 1) {
            violations.add("mediaType.ambiguous", locator, new Locator(bestMatches.get(0).getValue()), new Locator(bestMatches.get(1).getValue()));
            return null;
        }
        return new MediaTypeMatch(targetType, mediaTypes.keySet(), bestMatches.get(0).getKey(), bestMatches.get(0).getValue());
    }

    private static Map<MediaType, RamlBody> mediaTypes(RamlViolations violations, List<RamlBody> bodies, Locator locator) {
        LinkedHashMap<MediaType, RamlBody> types = new LinkedHashMap<MediaType, RamlBody>();
        for (RamlBody body : bodies) {
            try {
                types.put(MediaType.valueOf(body.name()), body);
            }
            catch (InvalidMediaTypeException e) {
                violations.add(new Message("mediaType.illegal", locator, body.name(), e.getMessage()));
            }
        }
        return types;
    }

    private static List<Map.Entry<MediaType, RamlBody>> findBestMatches(Map<MediaType, RamlBody> types, MediaType targetType) {
        ArrayList<Map.Entry<MediaType, RamlBody>> bestMatches = new ArrayList<Map.Entry<MediaType, RamlBody>>();
        for (Map.Entry<MediaType, RamlBody> entry : types.entrySet()) {
            int similarity = targetType.similarity(entry.getKey());
            if (bestMatches.isEmpty()) {
                if (similarity <= 0) continue;
                bestMatches.add(entry);
                continue;
            }
            int bestSimilarity = targetType.similarity((MediaType)((Map.Entry)bestMatches.get(0)).getKey());
            if (similarity > bestSimilarity) {
                bestMatches.clear();
                bestMatches.add(entry);
                continue;
            }
            if (similarity != bestSimilarity) continue;
            bestMatches.add(entry);
        }
        return bestMatches;
    }
}

