/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CheckerConfig;
import guru.nidi.ramltester.core.CheckerHelper;
import guru.nidi.ramltester.core.ContentNegotiationChecker;
import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.MediaTypeMatch;
import guru.nidi.ramltester.core.NamedReader;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlViolationException;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.RamlViolationsPerSecurity;
import guru.nidi.ramltester.core.ResourceMatch;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.core.SecurityExtractor;
import guru.nidi.ramltester.core.TypeChecker;
import guru.nidi.ramltester.core.Usage;
import guru.nidi.ramltester.core.UsageBuilder;
import guru.nidi.ramltester.core.VariableMatcher;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.RamlResponse;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.model.internal.RamlApi;
import guru.nidi.ramltester.model.internal.RamlApiResponse;
import guru.nidi.ramltester.model.internal.RamlBody;
import guru.nidi.ramltester.model.internal.RamlMethod;
import guru.nidi.ramltester.model.internal.RamlResource;
import guru.nidi.ramltester.model.internal.RamlSecScheme;
import guru.nidi.ramltester.model.internal.RamlType;
import guru.nidi.ramltester.util.FormDecoder;
import guru.nidi.ramltester.util.Message;
import guru.nidi.ramltester.util.UriComponents;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RamlChecker {
    private final CheckerConfig config;
    private final RamlApi api;
    private RamlViolations requestViolations;
    private RamlViolationsPerSecurity violationsPerSecurity;
    private Locator locator;
    private Usage usage;

    public RamlChecker(CheckerConfig config) {
        this.config = config;
        this.api = config.getRaml();
    }

    public RamlReport check(RamlRequest request) {
        return this.check(request, null);
    }

    public RamlReport check(RamlRequest request, RamlResponse response) {
        RamlReport report = new RamlReport(this.api);
        this.usage = report.getUsage();
        this.requestViolations = report.getRequestViolations();
        RamlViolations responseViolations = report.getResponseViolations();
        this.locator = new Locator();
        try {
            RamlMethod action = this.findAction(request);
            SecurityExtractor security = new SecurityExtractor(this.api, action, this.requestViolations);
            this.violationsPerSecurity = new RamlViolationsPerSecurity(security);
            this.checkRequest(request, action, security);
            if (response != null) {
                this.checkResponse(request, response, action, security);
            }
            this.violationsPerSecurity.addLeastViolations(this.requestViolations, responseViolations);
        }
        catch (RamlViolationException e) {
            // empty catch block
        }
        if (this.config.failFast && !report.isEmpty()) {
            throw new RamlViolationException(report);
        }
        return report;
    }

    public RamlMethod findAction(RamlRequest request) {
        UriComponents requestUri = UriComponents.fromHttpUrl(request.getRequestUrl(this.config.baseUri, this.config.includeServletPath));
        if (this.api.baseUri() == null) {
            UriComponents ramlUri = UriComponents.fromHttpUrl("http://server");
            VariableMatcher pathMatch = this.getPathMatch(requestUri, ramlUri);
            return this.findAction(pathMatch.getSuffix(), request.getMethod());
        }
        UriComponents ramlUri = UriComponents.fromHttpUrl(this.api.baseUri());
        VariableMatcher hostMatch = this.getHostMatch(requestUri, ramlUri);
        VariableMatcher pathMatch = this.getPathMatch(requestUri, ramlUri);
        RamlMethod action = this.findAction(pathMatch.getSuffix(), request.getMethod());
        this.checkProtocol(action, requestUri, ramlUri);
        this.checkBaseUriParameters(hostMatch, pathMatch, action);
        return action;
    }

    private RamlMethod findAction(String path, String method) {
        RamlResource resource = this.findResourceByPath(path);
        UsageBuilder.resourceUsage(this.usage, resource).incUses(1);
        RamlMethod action = this.findAction(resource, method);
        if (action == null) {
            this.requestViolations.add("action.undefined", this.locator, method);
            throw new RamlViolationException();
        }
        UsageBuilder.actionUsage(this.usage, action).incUses(1);
        this.locator.action(action);
        return action;
    }

    private RamlMethod findAction(RamlResource resource, String method) {
        for (RamlMethod action : resource.methods()) {
            if (!action.method().equals(method)) continue;
            return action;
        }
        return null;
    }

    private RamlResource findResourceByPath(String resourcePath) {
        Values values = new Values();
        List<ResourceMatch> matches = ResourceMatch.find(resourcePath, this.api.resources(), values);
        if (matches.isEmpty()) {
            this.requestViolations.add("resource.undefined", resourcePath);
            throw new RamlViolationException();
        }
        if (matches.size() > 1 && matches.get(0).compareTo(matches.get(1)) == 0) {
            this.requestViolations.add("resource.ambiguous", resourcePath, matches.get((int)0).resource.relativeUri(), matches.get((int)1).resource.relativeUri());
            throw new RamlViolationException();
        }
        RamlResource resource = matches.get((int)0).resource;
        this.locator.resource(resource);
        this.checkUriParams(values, resource);
        return resource;
    }

    public void checkRequest(RamlRequest request, RamlMethod action, SecurityExtractor security) {
        this.checkQueryParameters(request.getQueryValues(), action, security);
        this.checkRequestHeaderParameters(request.getHeaderValues(), action, security);
        MediaTypeMatch typeMatch = MediaTypeMatch.find(this.requestViolations, request, action.body(), this.locator);
        if (typeMatch != null) {
            this.locator.requestMime(typeMatch.getMatchingMime());
            if (FormDecoder.supportsFormParameters(typeMatch.getTargetType())) {
                this.checkFormParameters(action, request.getFormValues(), typeMatch.getMatchingMime());
            } else {
                this.checkSchema(this.requestViolations, request.getContent(), typeMatch);
            }
        }
    }

    private void checkFormParameters(RamlMethod action, Values values, RamlBody mimeType) {
        List<RamlType> formParameters;
        if (mimeType.type() != null) {
            this.requestViolations.add("schema.superfluous", this.locator);
        }
        if ((formParameters = mimeType.formParameters()).isEmpty()) {
            this.requestViolations.add("formParameters.missing", this.locator);
        } else {
            this.checkFormParametersValues(action, mimeType, values, formParameters);
        }
    }

    private void checkFormParametersValues(RamlMethod action, RamlBody mimeType, Values values, List<RamlType> formParameters) {
        Usage.MimeType mt = UsageBuilder.mimeTypeUsage(this.usage, action, mimeType);
        mt.addFormParameters(new TypeChecker(this.requestViolations).check(formParameters, values, new Message("formParam", this.locator)));
    }

    private void checkQueryParameters(Values values, RamlMethod action, SecurityExtractor security) {
        for (RamlSecScheme scheme : security.getSchemes()) {
            Usage.Action a = UsageBuilder.actionUsage(this.usage, action);
            a.addQueryParameters(new TypeChecker(this.violationsPerSecurity.requestViolations(scheme)).check(CheckerHelper.mergeLists(action.queryParameters(), security.queryParameters(scheme)), values, new Message("queryParam", this.locator)));
        }
    }

    private void checkRequestHeaderParameters(Values values, RamlMethod action, SecurityExtractor security) {
        for (RamlSecScheme scheme : security.getSchemes()) {
            Usage.Action a = UsageBuilder.actionUsage(this.usage, action);
            a.addRequestHeaders(new TypeChecker(this.violationsPerSecurity.requestViolations(scheme)).acceptWildcard().ignoreX(this.config.ignoreXheaders).caseSensitive(false).predefined(DefaultHeaders.REQUEST).check(CheckerHelper.mergeLists(action.headers(), security.headers(scheme)), values, new Message("headerParam", this.locator)));
        }
    }

    private void checkBaseUriParameters(VariableMatcher hostMatch, VariableMatcher pathMatch, RamlMethod action) {
        TypeChecker checker = new TypeChecker(this.requestViolations).acceptUndefined().ignoreRequired();
        List<RamlType> baseUriParams = CheckerHelper.getEffectiveBaseUriParams(this.api.baseUriParameters(), action);
        checker.check(baseUriParams, hostMatch.getVariables(), new Message("baseUriParam", this.locator));
        checker.check(baseUriParams, pathMatch.getVariables(), new Message("baseUriParam", this.locator));
    }

    private VariableMatcher getPathMatch(UriComponents requestUri, UriComponents ramlUri) {
        VariableMatcher pathMatch = VariableMatcher.match(ramlUri.getPath(), requestUri.getPath());
        if (!pathMatch.isMatch()) {
            this.requestViolations.add("baseUri.unmatched", requestUri.getUri(), this.api.baseUri());
            throw new RamlViolationException();
        }
        return pathMatch;
    }

    private VariableMatcher getHostMatch(UriComponents requestUri, UriComponents ramlUri) {
        VariableMatcher hostMatch = VariableMatcher.match(ramlUri.getHost(), requestUri.getHost());
        if (!hostMatch.isCompleteMatch()) {
            this.requestViolations.add("baseUri.unmatched", requestUri.getUri(), this.api.baseUri());
            throw new RamlViolationException();
        }
        return hostMatch;
    }

    private void checkProtocol(RamlMethod action, UriComponents requestUri, UriComponents ramlUri) {
        List<String> protocols = this.findProtocols(action, ramlUri.getScheme().toUpperCase());
        this.requestViolations.addIf(!protocols.contains(requestUri.getScheme().toUpperCase()), "protocol.undefined", this.locator, requestUri.getScheme());
    }

    private List<String> findProtocols(RamlMethod action, String fallback) {
        List<String> protocols = action.protocols();
        if (protocols == null || protocols.isEmpty()) {
            protocols = this.api.protocols();
        }
        if (protocols == null || protocols.isEmpty()) {
            protocols = Collections.singletonList(fallback);
        }
        return protocols;
    }

    private void checkUriParams(Values values, RamlResource resource) {
        for (Map.Entry<String, List<Object>> entry : values) {
            RamlType uriParam = CheckerHelper.findUriParam(entry.getKey(), resource);
            Message message = new Message("uriParam", this.locator, entry.getKey());
            if (uriParam == null) continue;
            new TypeChecker(this.requestViolations).check(uriParam, entry.getValue().get(0), message);
        }
    }

    public void checkResponse(RamlRequest request, RamlResponse response, RamlMethod action, SecurityExtractor security) {
        for (RamlSecScheme scheme : security.getSchemes()) {
            RamlViolations requestViolations = this.violationsPerSecurity.requestViolations(scheme);
            RamlViolations responseViolations = this.violationsPerSecurity.responseViolations(scheme);
            MediaTypeMatch typeMatch = this.doCheckReponse(responseViolations, response, action, security.responses(scheme));
            if (typeMatch == null) continue;
            new ContentNegotiationChecker(requestViolations, responseViolations).check(request, response, action, typeMatch);
        }
    }

    private MediaTypeMatch doCheckReponse(RamlViolations violations, RamlResponse response, RamlMethod action, List<RamlApiResponse> securityResponses) {
        List<RamlApiResponse> responseMap = CheckerHelper.mergeLists(action.responses(), securityResponses);
        RamlApiResponse res = CheckerHelper.responseByCode(responseMap, Integer.toString(response.getStatus()));
        if (res == null) {
            violations.add("responseCode.undefined", this.locator, response.getStatus());
            return null;
        }
        String statusStr = Integer.toString(response.getStatus());
        UsageBuilder.actionUsage(this.usage, action).addResponseCode(statusStr);
        this.locator.responseCode(statusStr);
        this.checkResponseHeaderParameters(violations, response.getHeaderValues(), action, statusStr, res);
        MediaTypeMatch typeMatch = MediaTypeMatch.find(violations, response, res.body(), this.locator);
        if (typeMatch != null) {
            this.locator.responseMime(typeMatch.getMatchingMime());
            this.checkSchema(violations, response.getContent(), typeMatch);
        }
        return typeMatch;
    }

    private void checkSchema(RamlViolations violations, byte[] body, MediaTypeMatch typeMatch) {
        String typeDef = typeMatch.getMatchingMime().typeDefinition();
        String type = typeMatch.getMatchingMime().type();
        if (typeDef == null && type == null) {
            return;
        }
        SchemaValidator validator = CheckerHelper.findSchemaValidator(this.config.schemaValidators, typeMatch.getTargetType());
        if (validator == null) {
            violations.add("schemaValidator.missing", this.locator, typeMatch.getTargetType());
            return;
        }
        if (body == null || body.length == 0) {
            violations.add("body.empty", this.locator, typeMatch.getTargetType());
            return;
        }
        String charset = typeMatch.getTargetCharset();
        try {
            String content = new String(body, charset);
            validator.validate(new NamedReader(content, new Message("body", new Object[0]).toString()), CheckerHelper.resolveSchema(type, typeDef), violations, new Message("schema.body.mismatch", this.locator, content));
        }
        catch (UnsupportedEncodingException e) {
            violations.add("charset.invalid", charset);
        }
    }

    private void checkResponseHeaderParameters(RamlViolations violations, Values values, RamlMethod action, String responseCode, RamlApiResponse response) {
        Usage.Response r = UsageBuilder.responseUsage(this.usage, action, responseCode);
        r.addResponseHeaders(new TypeChecker(violations).acceptWildcard().ignoreX(this.config.ignoreXheaders).caseSensitive(false).predefined(DefaultHeaders.RESPONSE).check(response.headers(), values, new Message("headerParam", this.locator)));
    }

    private static final class DefaultHeaders {
        private static final Set<String> REQUEST = new HashSet<String>(Arrays.asList("accept", "accept-charset", "accept-encoding", "accept-language", "accept-datetime", "authorization", "cache-control", "connection", "cookie", "content-length", "content-md5", "content-type", "date", "dnt", "expect", "from", "host", "if-match", "if-modified-since", "if-none-match", "if-range", "if-unmodified-since", "max-forwards", "origin", "pragma", "proxy-authorization", "range", "referer", "te", "user-agent", "upgrade", "via", "warning"));
        private static final Set<String> RESPONSE = new HashSet<String>(Arrays.asList("access-control-allow-origin", "accept-ranges", "age", "allow", "cache-control", "connection", "content-encoding", "content-language", "content-length", "content-location", "content-md5", "content-disposition", "content-range", "content-type", "date", "etag", "expires", "last-modified", "link", "location", "p3p", "pragma", "proxy-authenticate", "refresh", "retry-after", "server", "set-cookie", "status", "strict-transport-security", "trailer", "transfer-encoding", "upgrade", "vary", "via", "warning", "www-authenticate", "x-frame-options"));

        private DefaultHeaders() {
        }
    }
}

