/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.Usage;
import guru.nidi.ramltester.model.internal.RamlApi;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.common.ValidationResult;

public class RamlReport {
    private final RamlApi raml;
    private final Usage usage = new Usage();
    private final RamlViolations requestViolations = new RamlViolations();
    private final RamlViolations responseViolations = new RamlViolations();
    private final RamlViolations validationViolations = new RamlViolations();

    public RamlReport(RamlApi raml) {
        this.raml = raml;
    }

    public static RamlReport fromModelResult(RamlApi raml, RamlModelResult modelResult) {
        RamlReport report = new RamlReport(raml);
        for (ValidationResult result : modelResult.getValidationResults()) {
            report.getValidationViolations().add("checking.exception", result.toString());
        }
        return report;
    }

    public boolean isEmpty() {
        return this.requestViolations.isEmpty() && this.responseViolations.isEmpty() && this.validationViolations.isEmpty();
    }

    public String toString() {
        return "RamlReport{requestViolations=" + this.requestViolations + ", responseViolations=" + this.responseViolations + ", validationViolations=" + this.validationViolations + '}';
    }

    Usage getUsage() {
        return this.usage;
    }

    public RamlApi getRaml() {
        return this.raml;
    }

    public RamlViolations getRequestViolations() {
        return this.requestViolations;
    }

    public RamlViolations getResponseViolations() {
        return this.responseViolations;
    }

    public RamlViolations getValidationViolations() {
        return this.validationViolations;
    }
}

