/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CheckerHelper;
import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlValidatorChecker;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.core.Validation;
import guru.nidi.ramltester.model.internal.RamlApi;
import guru.nidi.ramltester.model.internal.RamlApiResponse;
import guru.nidi.ramltester.model.internal.RamlBody;
import guru.nidi.ramltester.model.internal.RamlMethod;
import guru.nidi.ramltester.model.internal.RamlResource;
import java.util.List;

public class RamlValidator {
    private final RamlApi raml;
    private final List<SchemaValidator> schemaValidators;
    private final Locator locator;
    private final RamlValidatorChecker checker;

    public RamlValidator(RamlApi raml, List<SchemaValidator> schemaValidators) {
        this(raml, schemaValidators, new RamlValidatorChecker(raml, schemaValidators));
    }

    private RamlValidator(RamlApi raml, List<SchemaValidator> schemaValidators, RamlValidatorChecker checker) {
        this.raml = raml;
        this.schemaValidators = schemaValidators;
        this.checker = checker;
        this.locator = checker.getLocator();
    }

    public RamlValidator withChecks(Validation ... validations) {
        return new RamlValidator(this.raml, this.schemaValidators, this.checker.withChecks(validations));
    }

    public RamlValidator withResourcePattern(String regex) {
        return new RamlValidator(this.raml, this.schemaValidators, this.checker.withResourcePattern(regex));
    }

    public RamlValidator withParameterPattern(String regex) {
        return new RamlValidator(this.raml, this.schemaValidators, this.checker.withParameterPattern(regex));
    }

    public RamlValidator withHeaderPattern(String regex) {
        return new RamlValidator(this.raml, this.schemaValidators, this.checker.withHeaderPattern(regex));
    }

    public RamlReport validate() {
        this.checker.parameters(this.raml.baseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.parameters(this.raml.annotationTypes(), RamlValidatorChecker.ParamName.ANNOTATION);
        this.checker.description(this.raml.documentation());
        this.checker.description(this.raml.description());
        this.checker.description(this.raml.baseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.description(this.raml.annotationTypes(), RamlValidatorChecker.ParamName.ANNOTATION);
        for (RamlResource resource : this.raml.resources()) {
            this.resource(resource);
        }
        return this.checker.getReport();
    }

    private void resource(RamlResource resource) {
        this.locator.resource(resource);
        this.checker.resourcePattern(resource);
        this.checker.uriParameters(CheckerHelper.typeNamesOf(resource.uriParameters()), resource);
        this.checker.parameters(resource.baseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.parameters(resource.uriParameters(), RamlValidatorChecker.ParamName.URI);
        this.checker.description(resource.description());
        this.checker.description(resource.baseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.description(resource.uriParameters(), RamlValidatorChecker.ParamName.URI);
        this.checker.empty(resource);
        for (RamlResource res : resource.resources()) {
            this.resource(res);
        }
        for (RamlMethod action : resource.methods()) {
            this.action(action);
        }
    }

    private void action(RamlMethod action) {
        this.locator.action(action);
        this.checker.parameters(action.baseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.parameters(action.queryParameters(), RamlValidatorChecker.ParamName.QUERY);
        this.checker.headerPattern(CheckerHelper.typeNamesOf(action.headers()));
        this.checker.description(action.description());
        this.checker.description(action.baseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.description(action.queryParameters(), RamlValidatorChecker.ParamName.QUERY);
        this.checker.description(action.headers(), RamlValidatorChecker.ParamName.HEADER);
        this.checker.empty(action);
        if (action.body() != null) {
            for (RamlBody mimeType : action.body()) {
                this.locator.requestMime(mimeType);
                this.mimeType(mimeType);
            }
        }
        for (RamlApiResponse response : action.responses()) {
            this.locator.responseCode(response.code());
            this.response(response);
        }
    }

    private void mimeType(RamlBody mimeType) {
        if (!mimeType.formParameters().isEmpty()) {
            this.checker.formParameters(mimeType);
            this.checker.parameters(mimeType.formParameters(), RamlValidatorChecker.ParamName.FORM);
            this.checker.description(mimeType.formParameters(), RamlValidatorChecker.ParamName.FORM);
        }
        this.checker.exampleSchema(mimeType);
    }

    private void response(RamlApiResponse response) {
        this.checker.headerPattern(CheckerHelper.typeNamesOf(response.headers()));
        this.checker.description(response.description());
        this.checker.description(response.headers(), RamlValidatorChecker.ParamName.HEADER);
        if (response.body() != null) {
            for (RamlBody mimeType : response.body()) {
                this.locator.responseMime(mimeType);
                this.mimeType(mimeType);
            }
        }
    }
}

