/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CheckerHelper;
import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.NamedReader;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.core.TypeChecker;
import guru.nidi.ramltester.core.Validation;
import guru.nidi.ramltester.model.internal.RamlApi;
import guru.nidi.ramltester.model.internal.RamlBody;
import guru.nidi.ramltester.model.internal.RamlDocItem;
import guru.nidi.ramltester.model.internal.RamlMethod;
import guru.nidi.ramltester.model.internal.RamlResource;
import guru.nidi.ramltester.model.internal.RamlType;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;

class RamlValidatorChecker {
    private final RamlApi raml;
    private final Locator locator;
    private final Pattern resourcePattern;
    private final Pattern parameterPattern;
    private final Pattern headerPattern;
    private final List<SchemaValidator> schemaValidators;
    private final EnumSet<Validation> validations;
    private final RamlReport report;
    private final RamlViolations violations;

    public RamlValidatorChecker(RamlApi raml, List<SchemaValidator> schemaValidators) {
        this(raml, new Locator(), schemaValidators, EnumSet.allOf(Validation.class), null, null, null);
    }

    public RamlValidatorChecker(RamlApi raml, Locator locator, List<SchemaValidator> schemaValidators, EnumSet<Validation> validations, Pattern resourcePattern, Pattern parameterPattern, Pattern headerPattern) {
        this.raml = raml;
        this.locator = locator;
        this.resourcePattern = resourcePattern;
        this.parameterPattern = parameterPattern;
        this.headerPattern = headerPattern;
        this.schemaValidators = schemaValidators;
        this.validations = validations;
        this.report = new RamlReport(raml);
        this.violations = this.report.getValidationViolations();
    }

    public RamlValidatorChecker withChecks(Validation ... validations) {
        EnumSet<Validation> validationSet = validations.length == 0 ? EnumSet.noneOf(Validation.class) : EnumSet.copyOf(Arrays.asList(validations));
        return new RamlValidatorChecker(this.raml, this.locator, this.schemaValidators, validationSet, this.headerPattern, this.parameterPattern, this.resourcePattern);
    }

    public RamlValidatorChecker withResourcePattern(String regex) {
        return new RamlValidatorChecker(this.raml, this.locator, this.schemaValidators, this.validations, regex == null ? null : Pattern.compile(regex), this.parameterPattern, this.headerPattern);
    }

    public RamlValidatorChecker withParameterPattern(String regex) {
        return new RamlValidatorChecker(this.raml, this.locator, this.schemaValidators, this.validations, this.resourcePattern, regex == null ? null : Pattern.compile(regex), this.headerPattern);
    }

    public RamlValidatorChecker withHeaderPattern(String regex) {
        return new RamlValidatorChecker(this.raml, this.locator, this.schemaValidators, this.validations, this.resourcePattern, this.parameterPattern, regex == null ? null : Pattern.compile(regex));
    }

    public Locator getLocator() {
        return this.locator;
    }

    public RamlReport getReport() {
        return this.report;
    }

    private boolean has(Validation validation) {
        return this.validations.contains((Object)validation);
    }

    private void violation(String key, Object ... params) {
        this.violations.add(new Message(key, params));
    }

    public void description(List<RamlType> params, ParamName paramName) {
        if (this.has(Validation.DESCRIPTION)) {
            for (RamlType param : params) {
                this.description(param.name(), param, paramName);
            }
        }
    }

    private void description(String name, RamlType param, ParamName paramName) {
        if (this.isNullOrEmpty(param.description())) {
            this.violation("parameter.description.missing", new Object[]{this.locator, name, paramName});
        }
    }

    public void description(String desc) {
        if (this.has(Validation.DESCRIPTION) && this.isNullOrEmpty(desc)) {
            this.violation("description.missing", this.locator);
        }
    }

    public void description(List<RamlDocItem> docs) {
        if (this.has(Validation.DESCRIPTION)) {
            if (this.isNullOrEmpty(docs)) {
                this.violation("documentation.missing", this.locator);
            } else {
                for (RamlDocItem doc : docs) {
                    if (this.isNullOrEmpty(doc.title())) {
                        this.violation("documentation.missing.title", this.locator);
                        continue;
                    }
                    if (!this.isNullOrEmpty(doc.content())) continue;
                    this.violation("documentation.missing.content", this.locator);
                }
            }
        }
    }

    public void empty(RamlResource resource) {
        if (this.has(Validation.EMPTY) && resource.methods().isEmpty() && resource.resources().isEmpty()) {
            this.violation("empty", this.locator);
        }
    }

    public void empty(RamlMethod action) {
        if (this.has(Validation.EMPTY) && action.responses().isEmpty()) {
            this.violation("empty", this.locator);
        }
    }

    private void baseUriParameters(Collection<String> names) {
        if (this.has(Validation.URI_PARAMETER)) {
            if (this.raml.baseUri() == null && !names.isEmpty()) {
                this.violation("baseUriParameters.illegal", this.locator);
            } else {
                for (String name : names) {
                    if ("version".equals(name)) {
                        this.violation("baseUriParameter.illegal", this.locator, name);
                        continue;
                    }
                    if (this.raml.baseUri().contains("{" + name + "}")) continue;
                    this.violation("baseUriParameter.invalid", this.locator, name);
                }
            }
        }
    }

    public void uriParameters(Collection<String> names, RamlResource resource) {
        if (this.has(Validation.URI_PARAMETER)) {
            for (String name : names) {
                if ("version".equals(name)) {
                    this.violation("uriParameter.illegal", this.locator, name);
                    continue;
                }
                if (resource.resourcePath().contains("{" + name + "}")) continue;
                this.violation("uriParameter.invalid", this.locator, name);
            }
        }
    }

    public void resourcePattern(RamlResource resource) {
        if (this.resourcePattern != null) {
            String uri = resource.relativeUri().replaceAll("\\{[^}/]+}", "");
            for (String part : uri.split("/")) {
                if (part == null || part.length() <= 0 || this.resourcePattern.matcher(part).matches()) continue;
                this.violation("resource.name.invalid", this.locator, this.resourcePattern.pattern());
            }
        }
    }

    public void parameters(List<RamlType> params, ParamName paramName) {
        if (paramName == ParamName.BASE_URI) {
            this.baseUriParameters(CheckerHelper.typeNamesOf(params));
        }
        if (this.parameterPattern != null) {
            for (RamlType param : params) {
                if (this.parameterPattern.matcher(param.name()).matches()) continue;
                this.violation("parameter.name.invalid", new Object[]{this.locator, param.name(), paramName, this.parameterPattern.pattern()});
            }
        }
        if (this.has(Validation.EXAMPLE)) {
            for (RamlType param : params) {
                this.parameterValues(param, new Message("parameter.condition", new Object[]{this.locator, param.name(), paramName}));
            }
        }
    }

    public void formParameters(RamlBody mimeType) {
        if (this.has(Validation.PARAMETER) && !MediaType.valueOf(mimeType.name()).isCompatibleWith(MediaType.FORM_URL_ENCODED) && !MediaType.valueOf(mimeType.name()).isCompatibleWith(MediaType.MULTIPART)) {
            this.violation("formParameter.illegal", this.locator);
        }
    }

    private void parameterValues(RamlType param, Message message) {
        TypeChecker checker = new TypeChecker(this.violations);
        for (String example : param.examples()) {
            checker.check(param, example, message.withParam("example"));
        }
        if (param.defaultValue() != null) {
            checker.check(param, param.defaultValue(), message.withParam("default value"));
        }
    }

    public void headerPattern(Collection<String> names) {
        if (this.headerPattern != null) {
            for (String name : names) {
                if (this.headerPattern.matcher(name).matches()) continue;
                this.violation("header.name.invalid", this.locator, name, this.headerPattern.pattern());
            }
        }
    }

    public void exampleSchema(RamlBody mimeType) {
        if (this.has(Validation.EXAMPLE)) {
            String typeDef = mimeType.typeDefinition();
            String type = mimeType.type();
            SchemaValidator validator = CheckerHelper.findSchemaValidator(this.schemaValidators, MediaType.valueOf(mimeType.name()));
            if ((typeDef != null || type != null) && validator != null) {
                for (String example : mimeType.examples()) {
                    validator.validate(new NamedReader(example, new Message("example", new Object[0]).toString()), CheckerHelper.resolveSchema(type, typeDef), this.violations, new Message("schema.example.mismatch", this.locator, example));
                }
            }
        }
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private boolean isNullOrEmpty(List<?> s) {
        return s == null || s.isEmpty();
    }

    static enum ParamName {
        BASE_URI("baseUriParameter"),
        URI("uriParameter"),
        QUERY("queryParameter"),
        HEADER("header"),
        FORM("formParameter"),
        ANNOTATION("annotationType");

        private final String value;

        private ParamName(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

