/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.RamlViolationMessage;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SecurityExtractor;
import guru.nidi.ramltester.model.internal.RamlSecScheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RamlViolationsPerSecurity {
    private static final Comparator<RamlSecScheme> SCHEME_COMPARATOR = new Comparator<RamlSecScheme>(){

        @Override
        public int compare(RamlSecScheme s1, RamlSecScheme s2) {
            return s1.type().compareToIgnoreCase(s2.type());
        }
    };
    private final List<RamlSecScheme> schemes;
    private final Map<String, RamlViolations> requestViolations;
    private final Map<String, RamlViolations> responseViolations;

    public RamlViolationsPerSecurity(SecurityExtractor security) {
        this.schemes = new ArrayList<RamlSecScheme>(security.getSchemes());
        Collections.sort(this.schemes, SCHEME_COMPARATOR);
        this.requestViolations = new HashMap<String, RamlViolations>();
        this.responseViolations = new HashMap<String, RamlViolations>();
        for (RamlSecScheme scheme : this.schemes) {
            this.requestViolations.put(scheme.type(), new RamlViolations());
            this.responseViolations.put(scheme.type(), new RamlViolations());
        }
    }

    public RamlViolations requestViolations(RamlSecScheme scheme) {
        return this.requestViolations.get(scheme.type());
    }

    public RamlViolations responseViolations(RamlSecScheme scheme) {
        return this.responseViolations.get(scheme.type());
    }

    public List<RamlSecScheme> leastViolations() {
        int best = Integer.MAX_VALUE;
        ArrayList<RamlSecScheme> res = new ArrayList<RamlSecScheme>();
        for (RamlSecScheme scheme : this.schemes) {
            int violations = this.requestViolations(scheme).size() + this.responseViolations(scheme).size();
            if (violations > best) continue;
            if (violations < best) {
                res.clear();
            }
            res.add(scheme);
            best = violations;
        }
        return res;
    }

    public void addLeastViolations(RamlViolations request, RamlViolations response) {
        for (RamlSecScheme scheme : this.leastViolations()) {
            this.addAll(scheme, this.requestViolations(scheme), request);
            this.addAll(scheme, this.responseViolations(scheme), response);
        }
    }

    private void addAll(RamlSecScheme scheme, RamlViolations source, RamlViolations target) {
        if (this.schemes.size() == 1) {
            target.addAll(source);
        } else {
            for (RamlViolationMessage s : source) {
                target.add("scheme", scheme.type(), s);
            }
        }
    }

    public String toString() {
        return "RamlViolationsPerSecurity{requestViolations=" + this.requestViolations + ", responseViolations=" + this.responseViolations + '}';
    }
}

