/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.VariableMatcher;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.model.internal.RamlResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ResourceMatch
implements Comparable<ResourceMatch> {
    final VariableMatcher match;
    final RamlResource resource;

    private ResourceMatch(VariableMatcher match, RamlResource resource) {
        this.match = match;
        this.resource = resource;
    }

    public static List<ResourceMatch> find(String resourcePath, List<RamlResource> resources, Values values) {
        ArrayList<ResourceMatch> matches = new ArrayList<ResourceMatch>();
        for (RamlResource resource : resources) {
            VariableMatcher pathMatch = VariableMatcher.match(resource.relativeUri(), resourcePath);
            if (!pathMatch.isCompleteMatch() && (!pathMatch.isMatch() || !pathMatch.getSuffix().startsWith("/"))) continue;
            matches.add(new ResourceMatch(pathMatch, resource));
        }
        Collections.sort(matches);
        ArrayList<ResourceMatch> found = new ArrayList<ResourceMatch>();
        for (ResourceMatch match : matches) {
            if (match.match.isCompleteMatch()) {
                values.addValues(match.match.getVariables());
                found.add(match);
                continue;
            }
            if (!match.match.isMatch()) continue;
            values.addValues(match.match.getVariables());
            found.addAll(ResourceMatch.find(match.match.getSuffix(), match.resource.resources(), values));
        }
        return found;
    }

    @Override
    public int compareTo(ResourceMatch o) {
        return this.match.getVariables().size() - o.match.getVariables().size();
    }
}

