/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.model.internal.RamlApi;
import guru.nidi.ramltester.model.internal.RamlApiResponse;
import guru.nidi.ramltester.model.internal.RamlMethod;
import guru.nidi.ramltester.model.internal.RamlSecScheme;
import guru.nidi.ramltester.model.internal.RamlSecSchemePart;
import guru.nidi.ramltester.model.internal.RamlSecSchemeRef;
import guru.nidi.ramltester.model.internal.RamlSecSchemeSettings;
import guru.nidi.ramltester.model.internal.RamlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class SecurityExtractor {
    private final List<RamlSecScheme> schemes;

    public SecurityExtractor(RamlApi raml, RamlMethod action, RamlViolations violations) {
        this.schemes = new SchemeFinder(raml, violations).securedBy(action);
    }

    public List<RamlSecScheme> getSchemes() {
        return this.schemes;
    }

    public List<RamlType> queryParameters(RamlSecScheme scheme) {
        return scheme.describedBy() == null ? Collections.emptyList() : scheme.describedBy().queryParameters();
    }

    public List<RamlType> headers(RamlSecScheme scheme) {
        return scheme.describedBy() == null ? Collections.emptyList() : scheme.describedBy().headers();
    }

    public List<RamlApiResponse> responses(RamlSecScheme scheme) {
        return scheme.describedBy() == null ? Collections.emptyList() : scheme.describedBy().responses();
    }

    private static final class SchemeFinder {
        private static final RamlSecScheme NULL_SCHEMA = new RamlSecScheme(){

            @Override
            public String description() {
                return null;
            }

            @Override
            public String name() {
                return null;
            }

            @Override
            public String type() {
                return "null";
            }

            @Override
            public RamlSecSchemePart describedBy() {
                return null;
            }

            @Override
            public RamlSecSchemeSettings settings() {
                return null;
            }
        };
        private final RamlApi raml;
        private final RamlViolations violations;

        public SchemeFinder(RamlApi raml, RamlViolations violations) {
            this.raml = raml;
            this.violations = violations;
        }

        public List<RamlSecScheme> securedBy(RamlMethod action) {
            ArrayList<RamlSecScheme> res = new ArrayList<RamlSecScheme>();
            if (!action.securedBy().isEmpty()) {
                res.addAll(this.securitySchemes(action.securedBy()));
            } else if (!action.resource().securedBy().isEmpty()) {
                res.addAll(this.securitySchemes(action.resource().securedBy()));
            } else if (!this.raml.securedBy().isEmpty()) {
                res.addAll(this.securitySchemes(this.raml.securedBy()));
            }
            if (res.isEmpty()) {
                res.add(NULL_SCHEMA);
            }
            return res;
        }

        private List<RamlSecScheme> securitySchemes(List<RamlSecSchemeRef> refs) {
            ArrayList<RamlSecScheme> res = new ArrayList<RamlSecScheme>();
            for (RamlSecSchemeRef ref : refs) {
                res.add(ref.securityScheme() == null ? NULL_SCHEMA : ref.securityScheme());
            }
            return res;
        }
    }
}

