/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.JsRegex;
import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.util.FileValue;
import guru.nidi.ramltester.util.Message;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.raml.v2.api.model.v08.parameters.IntegerTypeDeclaration;
import org.raml.v2.api.model.v08.parameters.NumberTypeDeclaration;
import org.raml.v2.api.model.v08.parameters.Parameter;
import org.raml.v2.api.model.v08.parameters.StringTypeDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Type08Checker {
    private static final Pattern INTEGER = Pattern.compile("0|-?[1-9][0-9]*");
    private static final Pattern NUMBER = Pattern.compile("0|inf|-inf|nan|-?(((0?|[1-9][0-9]*)\\.[0-9]*[1-9])|([1-9][0-9]*))(e[-+]?[1-9][0-9]*)?");
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RamlViolations violations;

    public Type08Checker(RamlViolations violations) {
        this.violations = violations;
    }

    public void check(Parameter param, Object value, Message message) {
        if (value instanceof Collection) {
            for (Object v : (Collection)value) {
                this.doCheck(param, v, message);
            }
        } else {
            this.doCheck(param, value, message);
        }
    }

    private void doCheck(Parameter param, Object value, Message message) {
        if (value == null) {
            Message detail = message.withInnerParam(new Message("value", "empty"));
            this.checkNull(param, detail);
        } else {
            Message detail = message.withInnerParam(new Message("value", value));
            if (value instanceof String) {
                this.checkString(param, (String)value, detail);
            } else if (value instanceof FileValue) {
                this.checkFile(param, detail);
            } else {
                throw new IllegalArgumentException("Unhandled parameter value '" + value + "' of type " + value.getClass());
            }
        }
    }

    private void checkNull(Parameter param, Message detail) {
        if (param.type() == null || "string".equals(param.type())) {
            this.checkString(param, "", detail);
        } else {
            this.violations.add(detail.withMessageParam("value.empty", new Object[0]));
        }
    }

    private void checkFile(Parameter param, Message detail) {
        if (!"file".equals(param.type())) {
            this.violations.add(detail.withMessageParam("file.superfluous", param.type()));
        }
    }

    private void checkString(Parameter param, String value, Message detail) {
        if (param.type() == null) {
            return;
        }
        if ("boolean".equals(param.type())) {
            this.checkBoolean(value, detail);
        } else if ("date".equals(param.type())) {
            this.checkDate(value, detail);
        } else if ("file".equals(param.type())) {
            this.checkFile(detail);
        } else if ("integer".equals(param.type())) {
            this.checkInteger(param, value, detail);
        } else if ("number".equals(param.type())) {
            this.checkNumber(param, value, detail);
        } else if (param instanceof StringTypeDeclaration) {
            this.checkString((StringTypeDeclaration)param, value, detail);
        } else {
            throw new RamlCheckerException("Unhandled parameter type '" + param.type() + "'");
        }
    }

    private void checkString(StringTypeDeclaration param, String value, Message detail) {
        this.violations.addIf(param.enumValues() != null && !param.enumValues().isEmpty() && !param.enumValues().contains(value), detail.withMessageParam("enum.invalid", param.enumValues()));
        try {
            this.violations.addIf(param.pattern() != null && !JsRegex.matches(value, param.pattern()), detail.withMessageParam("pattern.invalid", param.pattern()));
        }
        catch (PatternSyntaxException e) {
            this.log.warn("Could not execute regex '" + param.pattern(), (Throwable)e);
        }
        this.violations.addIf(param.minLength() != null && value.length() < param.minLength(), detail.withMessageParam("length.tooSmall", param.minLength()));
        this.violations.addIf(param.maxLength() != null && value.length() > param.maxLength(), detail.withMessageParam("length.tooBig", param.maxLength()));
    }

    private void checkNumber(Parameter param, String value, Message detail) {
        if (NUMBER.matcher(value).matches()) {
            if (param instanceof NumberTypeDeclaration) {
                NumberTypeDeclaration numeric = (NumberTypeDeclaration)param;
                this.checkNumericLimits(numeric, Double.parseDouble(value), detail);
            }
        } else {
            this.violations.add(detail.withMessageParam("number.invalid", new Object[0]));
        }
    }

    private void checkInteger(Parameter param, String value, Message detail) {
        if (INTEGER.matcher(value).matches()) {
            if (param instanceof IntegerTypeDeclaration) {
                this.checkNumericLimits((NumberTypeDeclaration)param, Double.parseDouble(value), detail);
            }
        } else {
            this.violations.add(detail.withMessageParam("integer.invalid", new Object[0]));
        }
    }

    private void checkFile(Message detail) {
        this.violations.add(detail.withMessageParam("file.invalid", new Object[0]));
    }

    private void checkDate(String value, Message detail) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
            dateFormat.setLenient(false);
            dateFormat.parse(value);
        }
        catch (ParseException e) {
            this.violations.add(detail.withMessageParam("date.invalid", new Object[0]));
        }
    }

    private void checkBoolean(String value, Message detail) {
        this.violations.addIf(!"true".equals(value) && !"false".equals(value), detail.withMessageParam("boolean.invalid", new Object[0]));
    }

    private void checkNumericLimits(NumberTypeDeclaration param, double value, Message message) {
        this.violations.addIf(param.minimum() != null && param.minimum().compareTo(value) > 0, message.withMessageParam("value.tooSmall", param.minimum()));
        this.violations.addIf(param.maximum() != null && param.maximum().compareTo(value) < 0, message.withMessageParam("value.tooBig", param.maximum()));
    }
}

