/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.util.Message;
import java.util.Collection;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

class Type10Checker {
    private final RamlViolations violations;

    public Type10Checker(RamlViolations violations) {
        this.violations = violations;
    }

    public void check(TypeDeclaration type, Object value, Message message) {
        if (value instanceof Collection) {
            String et = this.elementType(type);
            if (et != null) {
                this.doCheck(type, this.join((Collection)value, "string".equals(et) ? "\"" : ""), message);
            }
        } else if (value == null) {
            if ("string".equals(type.type())) {
                this.doCheck(type, "", message);
            } else {
                this.violations.add(message.withInnerParam(new Message("value", "empty").withMessageParam("value.empty", new Object[0])));
            }
        } else {
            this.doCheck(type, value.toString(), message);
        }
    }

    private void doCheck(TypeDeclaration type, String value, Message message) {
        for (ValidationResult res : type.validate(value)) {
            this.violations.add(message.withInnerParam(new Message("value10", value, res.getMessage())));
        }
    }

    private String elementType(TypeDeclaration type) {
        String t = type.type();
        if (t.endsWith("[]")) {
            return t.substring(0, t.length() - 2);
        }
        if (type instanceof ArrayTypeDeclaration) {
            String items = ((ArrayTypeDeclaration)type).items().type();
            return "array".equals(items) ? "string" : items;
        }
        return null;
    }

    private String join(Collection<?> coll, String quote) {
        StringBuilder sb = new StringBuilder("[");
        for (Object c : coll) {
            sb.append(quote).append(c.toString()).append(quote).append(',');
        }
        return sb.replace(sb.length() - 1, sb.length(), "]").toString();
    }
}

