/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CheckerHelper;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.Type08Checker;
import guru.nidi.ramltester.core.Type10Checker;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.model.internal.RamlType;
import guru.nidi.ramltester.model.internal.Type08;
import guru.nidi.ramltester.model.internal.Type10;
import guru.nidi.ramltester.util.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TypeChecker {
    private static final String WILDCARD = "{?}";
    private final RamlViolations violations;
    private final boolean acceptUndefined;
    private final boolean acceptWildcard;
    private final boolean ignoreX;
    private final boolean caseSensitive;
    private final boolean ignoreRequired;
    private final Set<String> predefined;

    TypeChecker(RamlViolations violations, boolean acceptUndefined, boolean acceptWildcard, boolean ignoreX, boolean caseSensitive, boolean ignoreRequired, Set<String> predefined) {
        this.violations = violations;
        this.acceptUndefined = acceptUndefined;
        this.acceptWildcard = acceptWildcard;
        this.ignoreX = ignoreX;
        this.caseSensitive = caseSensitive;
        this.ignoreRequired = ignoreRequired;
        this.predefined = predefined;
    }

    public TypeChecker(RamlViolations violations) {
        this(violations, false, false, false, true, false, Collections.emptySet());
    }

    public TypeChecker acceptUndefined() {
        return new TypeChecker(this.violations, true, this.acceptWildcard, this.ignoreX, this.caseSensitive, this.ignoreRequired, this.predefined);
    }

    public TypeChecker acceptWildcard() {
        return new TypeChecker(this.violations, this.acceptUndefined, true, this.ignoreX, this.caseSensitive, this.ignoreRequired, this.predefined);
    }

    public TypeChecker ignoreX(boolean ignoreX) {
        return new TypeChecker(this.violations, this.acceptUndefined, this.acceptWildcard, ignoreX, this.caseSensitive, this.ignoreRequired, this.predefined);
    }

    public TypeChecker caseSensitive(boolean caseSensitive) {
        return new TypeChecker(this.violations, this.acceptUndefined, this.acceptWildcard, this.ignoreX, caseSensitive, this.ignoreRequired, this.predefined);
    }

    public TypeChecker ignoreRequired() {
        return new TypeChecker(this.violations, this.acceptUndefined, this.acceptWildcard, this.ignoreX, this.caseSensitive, true, this.predefined);
    }

    public TypeChecker predefined(Set<String> predefined) {
        return new TypeChecker(this.violations, this.acceptUndefined, this.acceptWildcard, this.ignoreX, this.caseSensitive, this.ignoreRequired, predefined);
    }

    public void check(RamlType type, Object value, Message message) {
        if (type instanceof Type08) {
            new Type08Checker(this.violations).check(((Type08)type).getDelegate(), value, message);
        } else if (type instanceof Type10) {
            new Type10Checker(this.violations).check(((Type10)type).getDelegate(), value, message);
        }
    }

    public Set<String> check(List<RamlType> types, Values values, Message message) {
        Message namedMsg;
        HashSet<String> found = new HashSet<String>();
        TypeChecker checker = new TypeChecker(this.violations);
        for (Map.Entry<String, List<Object>> entry : values) {
            namedMsg = message.withParam(entry.getKey());
            String typeName = this.findMatchingTypeName(CheckerHelper.typeNamesOf(types), entry.getKey());
            List<RamlType> ts = CheckerHelper.typesByName(types, typeName);
            if (ts == null || ts.isEmpty()) {
                this.violations.addIf(!this.acceptUndefined(entry.getKey().toLowerCase(Locale.ENGLISH)), namedMsg.withMessageParam("undefined", new Object[0]));
                continue;
            }
            for (RamlType t : ts) {
                if (entry.getValue().size() == 1) {
                    checker.check(t, entry.getValue().get(0), namedMsg);
                    continue;
                }
                this.violations.addIf(!t.repeat(), namedMsg.withMessageParam("repeat.superfluous", new Object[0]));
                checker.check(t, entry.getValue(), namedMsg);
            }
            found.add(typeName);
        }
        for (RamlType type : types) {
            namedMsg = message.withParam(type.name());
            this.violations.addIf(type.required() && !this.ignoreRequired && !found.contains(type.name()), namedMsg.withMessageParam("required.missing", new Object[0]));
        }
        return found;
    }

    private String findMatchingTypeName(Collection<String> typeNames, String name) {
        String normalName = this.normalizeName(name);
        for (String typeName : typeNames) {
            String normalType = this.normalizeName(typeName);
            int pos = normalType.indexOf(WILDCARD);
            if (!normalType.equals(normalName) && (!this.acceptWildcard || pos < 0 || !this.nameMatchesKeyStart(normalName, normalType, pos) || !this.nameMatchesKeyEnd(normalName, normalType, pos))) continue;
            return typeName;
        }
        return null;
    }

    private String normalizeName(String name) {
        return this.caseSensitive ? name : name.toLowerCase(Locale.ENGLISH);
    }

    private boolean nameMatchesKeyStart(String name, String key, int wildcardPos) {
        return wildcardPos == 0 || name.startsWith(key.substring(0, wildcardPos));
    }

    private boolean nameMatchesKeyEnd(String name, String key, int wildcardPos) {
        return wildcardPos == key.length() - WILDCARD.length() || name.endsWith(key.substring(wildcardPos + WILDCARD.length()));
    }

    private boolean acceptUndefined(String name) {
        return this.acceptUndefined || this.predefined.contains(name) || this.ignoreX && name.startsWith("x-");
    }
}

