/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CountSet;
import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.core.UsageCollector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Usage
implements Iterable<Map.Entry<String, Resource>> {
    private final Map<String, Resource> resources = new HashMap<String, Resource>();

    private static <T> T getOrCreate(Class<T> clazz, Map<String, T> map, String name) {
        T res = map.get(name);
        if (res == null) {
            try {
                res = clazz.newInstance();
                map.put(name, res);
            }
            catch (Exception e) {
                throw new RamlCheckerException("Could not create instance of " + clazz, e);
            }
        }
        return res;
    }

    public Resource resource(String path) {
        return Usage.getOrCreate(Resource.class, this.resources, path);
    }

    public void add(Usage usage) {
        for (Map.Entry<String, Resource> resourceEntry : usage) {
            Resource resource = this.resource(resourceEntry.getKey());
            resource.incUses(resourceEntry.getValue().getUses());
            for (Map.Entry<String, Action> actionEntry : resourceEntry.getValue()) {
                Action action = resource.action(actionEntry.getKey());
                Action usageAction = actionEntry.getValue();
                action.incUses(usageAction.getUses());
                action.addQueryParameters(usageAction.getQueryParameters());
                action.addRequestHeaders(usageAction.getRequestHeaders());
                action.addResponseCodes(usageAction.getResponseCodes());
                for (Map.Entry<String, Response> entry : usageAction.responses()) {
                    Response response = action.response(entry.getKey());
                    response.addResponseHeaders(entry.getValue().getResponseHeaders());
                }
                for (Map.Entry<String, Object> entry : usageAction.mimeTypes()) {
                    MimeType mimeType = action.mimeType(entry.getKey());
                    mimeType.addFormParameters(((MimeType)entry.getValue()).getFormParameters());
                }
            }
        }
    }

    public String toString() {
        return "Usage" + this.resources;
    }

    @Override
    public Iterator<Map.Entry<String, Resource>> iterator() {
        return this.resources.entrySet().iterator();
    }

    public Set<String> getUnusedResources() {
        HashSet<String> res = new HashSet<String>();
        for (Map.Entry<String, Resource> resourceEntry : this) {
            if (resourceEntry.getValue().getUses() != 0 || resourceEntry.getValue().actions.isEmpty()) continue;
            res.add(resourceEntry.getKey());
        }
        return res;
    }

    public Set<String> getUnusedActions() {
        return UsageCollector.ACTION.collect(this);
    }

    public Set<String> getUnusedQueryParameters() {
        return UsageCollector.QUERY_PARAM.collect(this);
    }

    public Set<String> getUnusedFormParameters() {
        return UsageCollector.FORM_PARAM.collect(this);
    }

    public Set<String> getUnusedRequestHeaders() {
        return UsageCollector.REQUEST_HEADER.collect(this);
    }

    public Set<String> getUnusedResponseHeaders() {
        return UsageCollector.RESPONSE_HEADER.collect(this);
    }

    public Set<String> getUnusedResponseCodes() {
        return UsageCollector.RESPONSE_CODE.collect(this);
    }

    static class MimeType {
        private final CountSet<String> formParameters = new CountSet();

        MimeType() {
        }

        public void addFormParameters(Set<String> names) {
            this.formParameters.addAll((Collection<String>)names);
        }

        public void initFormParameters(Collection<String> names) {
            this.formParameters.addAll(names, 0);
        }

        public CountSet<String> getFormParameters() {
            return this.formParameters;
        }

        public String toString() {
            return "MimeType{formParameters=" + this.formParameters + '}';
        }
    }

    static class Response {
        private final CountSet<String> responseHeaders = new CountSet();

        Response() {
        }

        public void addResponseHeaders(Set<String> names) {
            this.responseHeaders.addAll((Collection<String>)names);
        }

        public void initResponseHeaders(Collection<String> names) {
            this.responseHeaders.addAll(names, 0);
        }

        public CountSet<String> getResponseHeaders() {
            return this.responseHeaders;
        }

        public String toString() {
            return "Response{responseHeaders=" + this.responseHeaders + '}';
        }
    }

    static class Action
    extends UsageBase {
        private final Map<String, Response> responses = new HashMap<String, Response>();
        private final Map<String, MimeType> mimeTypes = new HashMap<String, MimeType>();
        private final CountSet<String> queryParameters = new CountSet();
        private final CountSet<String> requestHeaders = new CountSet();
        private final CountSet<String> responseCodes = new CountSet();

        Action() {
        }

        public Response response(String name) {
            return (Response)Usage.getOrCreate(Response.class, this.responses, name);
        }

        public Iterable<Map.Entry<String, Response>> responses() {
            return this.responses.entrySet();
        }

        public MimeType mimeType(String name) {
            return (MimeType)Usage.getOrCreate(MimeType.class, this.mimeTypes, name);
        }

        public Iterable<Map.Entry<String, MimeType>> mimeTypes() {
            return this.mimeTypes.entrySet();
        }

        public void addQueryParameters(Collection<String> names) {
            this.queryParameters.addAll(names);
        }

        public void initQueryParameters(Collection<String> names) {
            this.queryParameters.addAll(names, 0);
        }

        public void addRequestHeaders(Collection<String> names) {
            this.requestHeaders.addAll(names);
        }

        public void initRequestHeaders(Collection<String> names) {
            this.requestHeaders.addAll(names, 0);
        }

        public void addResponseCode(String name) {
            this.responseCodes.add(name);
        }

        public void addResponseCodes(Collection<String> names) {
            this.responseCodes.addAll(names);
        }

        public void initResponseCodes(Collection<String> names) {
            this.responseCodes.addAll(names, 0);
        }

        public CountSet<String> getQueryParameters() {
            return this.queryParameters;
        }

        public CountSet<String> getRequestHeaders() {
            return this.requestHeaders;
        }

        public CountSet<String> getResponseCodes() {
            return this.responseCodes;
        }

        public String toString() {
            return "Action{responses=" + this.responses + ", mimeTypes=" + this.mimeTypes + ", queryParameters=" + this.queryParameters + ", requestHeaders=" + this.requestHeaders + ", responseCodes=" + this.responseCodes + '}';
        }
    }

    static class Resource
    extends UsageBase
    implements Iterable<Map.Entry<String, Action>> {
        private final Map<String, Action> actions = new HashMap<String, Action>();

        Resource() {
        }

        public Action action(String name) {
            return (Action)Usage.getOrCreate(Action.class, this.actions, name);
        }

        public String toString() {
            return "Resource" + this.actions;
        }

        @Override
        public Iterator<Map.Entry<String, Action>> iterator() {
            return this.actions.entrySet().iterator();
        }
    }

    static class UsageBase {
        private int uses;

        UsageBase() {
        }

        public void incUses(int count) {
            this.uses += count;
        }

        public int getUses() {
            return this.uses;
        }
    }
}

