/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.CheckerHelper;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.Usage;
import guru.nidi.ramltester.model.internal.RamlApi;
import guru.nidi.ramltester.model.internal.RamlApiResponse;
import guru.nidi.ramltester.model.internal.RamlBody;
import guru.nidi.ramltester.model.internal.RamlMethod;
import guru.nidi.ramltester.model.internal.RamlResource;
import java.util.List;

public final class UsageBuilder {
    private UsageBuilder() {
    }

    static Usage.Resource resourceUsage(Usage usage, RamlResource resource) {
        return usage.resource(resource.resourcePath());
    }

    static Usage.Action actionUsage(Usage usage, RamlMethod action) {
        return usage.resource(action.resource().resourcePath()).action(action.method());
    }

    static Usage.Response responseUsage(Usage usage, RamlMethod action, String responseCode) {
        return UsageBuilder.actionUsage(usage, action).response(responseCode);
    }

    static Usage.MimeType mimeTypeUsage(Usage usage, RamlMethod action, RamlBody mimeType) {
        return UsageBuilder.actionUsage(usage, action).mimeType(mimeType.name());
    }

    public static Usage usage(RamlApi raml, List<RamlReport> reports) {
        Usage usage = new Usage();
        UsageBuilder.createTotalUsage(usage, raml.resources());
        for (RamlReport report : reports) {
            usage.add(report.getUsage());
        }
        return usage;
    }

    private static void createTotalUsage(Usage usage, List<RamlResource> resources) {
        for (RamlResource resource : resources) {
            UsageBuilder.resourceUsage(usage, resource);
            for (RamlMethod action : resource.methods()) {
                UsageBuilder.actionUsage(usage, action).initQueryParameters(CheckerHelper.typeNamesOf(action.queryParameters()));
                UsageBuilder.actionUsage(usage, action).initResponseCodes(CheckerHelper.codesOf(action.responses()));
                UsageBuilder.actionUsage(usage, action).initRequestHeaders(CheckerHelper.typeNamesOf(action.headers()));
                if (action.body() != null) {
                    for (RamlBody mimeType : action.body()) {
                        if (mimeType.formParameters().isEmpty()) continue;
                        UsageBuilder.mimeTypeUsage(usage, action, mimeType).initFormParameters(CheckerHelper.typeNamesOf(mimeType.formParameters()));
                    }
                }
                for (RamlApiResponse response : action.responses()) {
                    UsageBuilder.responseUsage(usage, action, response.code()).initResponseHeaders(CheckerHelper.typeNamesOf(response.headers()));
                }
            }
            UsageBuilder.createTotalUsage(usage, resource.resources());
        }
    }
}

