/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.Usage;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class UsageCollector {
    static final UsageCollector ACTION = new UsageCollector(){

        @Override
        public void collect(String key, Usage.Action action, Set<String> result) {
            if (action.getUses() == 0) {
                result.add(key);
            }
        }
    };
    static final UsageCollector QUERY_PARAM = new UsageCollector(){

        @Override
        public void collect(String key, Usage.Action action, Set<String> result) {
            for (Map.Entry<String, Integer> queryEntry : action.getQueryParameters().values()) {
                if (queryEntry.getValue() != 0) continue;
                2.add(result, queryEntry.getKey(), key);
            }
        }
    };
    static final UsageCollector FORM_PARAM = new UsageCollector(){

        @Override
        public void collect(String key, Usage.Action action, Set<String> result) {
            for (Map.Entry<String, Usage.MimeType> mimeTypeEntry : action.mimeTypes()) {
                for (Map.Entry<String, Integer> formEntry : mimeTypeEntry.getValue().getFormParameters().values()) {
                    if (formEntry.getValue() != 0) continue;
                    3.add(result, formEntry.getKey(), key + " (" + mimeTypeEntry.getKey() + ")");
                }
            }
        }
    };
    static final UsageCollector REQUEST_HEADER = new UsageCollector(){

        @Override
        public void collect(String key, Usage.Action action, Set<String> result) {
            for (Map.Entry<String, Integer> requestEntry : action.getRequestHeaders().values()) {
                if (requestEntry.getValue() != 0) continue;
                4.add(result, requestEntry.getKey(), key);
            }
        }
    };
    static final UsageCollector RESPONSE_HEADER = new UsageCollector(){

        @Override
        public void collect(String key, Usage.Action action, Set<String> result) {
            for (Map.Entry<String, Usage.Response> responseEntry : action.responses()) {
                for (Map.Entry<String, Integer> headerEntry : responseEntry.getValue().getResponseHeaders().values()) {
                    if (headerEntry.getValue() != 0) continue;
                    5.add(result, headerEntry.getKey(), key + " -> " + responseEntry.getKey());
                }
            }
        }
    };
    static final UsageCollector RESPONSE_CODE = new UsageCollector(){

        @Override
        public void collect(String key, Usage.Action action, Set<String> result) {
            for (Map.Entry<String, Integer> responseCodeEntry : action.getResponseCodes().values()) {
                if (responseCodeEntry.getValue() != 0) continue;
                6.add(result, responseCodeEntry.getKey(), key);
            }
        }
    };

    private UsageCollector() {
    }

    abstract void collect(String var1, Usage.Action var2, Set<String> var3);

    public Set<String> collect(Usage usage) {
        HashSet<String> res = new HashSet<String>();
        for (Map.Entry<String, Usage.Resource> resourceEntry : usage) {
            for (Map.Entry<String, Usage.Action> actionEntry : resourceEntry.getValue()) {
                this.collect(actionEntry.getKey() + " " + resourceEntry.getKey(), actionEntry.getValue(), res);
            }
        }
        return res;
    }

    protected static void add(Set<String> result, String key, String value) {
        result.add(key + " in " + value);
    }
}

